/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.api.text.EnumColor;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketGuiSetFrequencyColor<FREQ extends Frequency>
implements IMekanismPacket {
    private final FrequencyType<FREQ> frequencyType;
    private final Frequency.FrequencyIdentity identity;
    private final boolean next;

    private PacketGuiSetFrequencyColor(FrequencyType<FREQ> frequencyType, Frequency.FrequencyIdentity identity, boolean next) {
        this.frequencyType = frequencyType;
        this.identity = identity;
        this.next = next;
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequencyColor<FREQ> create(FREQ freq, boolean next) {
        return new PacketGuiSetFrequencyColor(freq.getType(), freq.getIdentity(), next);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        FREQ freq;
        ServerPlayer player = context.getSender();
        if (player != null && (freq = this.frequencyType.getFrequency(this.identity, player.m_20148_())) != null && ((Frequency)freq).ownerMatches(player.m_20148_())) {
            ((IColorableFrequency)freq).setColor(this.next ? (EnumColor)((IColorableFrequency)freq).getColor().getNext() : (EnumColor)((IColorableFrequency)freq).getColor().getPrevious());
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        this.frequencyType.write(buffer);
        this.frequencyType.getIdentitySerializer().write(buffer, this.identity);
        buffer.writeBoolean(this.next);
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequencyColor<FREQ> decode(FriendlyByteBuf buffer) {
        FrequencyType frequencyType = FrequencyType.load(buffer);
        Frequency.FrequencyIdentity identity = frequencyType.getIdentitySerializer().read(buffer);
        return new PacketGuiSetFrequencyColor(frequencyType, identity, buffer.readBoolean());
    }
}

