/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class RotaryRecipeSerializer<RECIPE extends RotaryRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public RotaryRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        FluidStackIngredient fluidInputIngredient = null;
        ChemicalStackIngredient.GasStackIngredient gasInputIngredient = null;
        GasStack gasOutput = null;
        FluidStack fluidOutput = null;
        boolean hasFluidToGas = false;
        boolean hasGasToFluid = false;
        if (json.has("fluidInput") || json.has("gasOutput")) {
            JsonArray fluidInput = GsonHelper.m_13885_((JsonObject)json, (String)"fluidInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"fluidInput") : GsonHelper.m_13930_((JsonObject)json, (String)"fluidInput");
            fluidInputIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)fluidInput);
            gasOutput = SerializerHelper.getGasStack(json, "gasOutput");
            hasFluidToGas = true;
            if (gasOutput.isEmpty()) {
                throw new JsonSyntaxException("Rotary recipe gas output cannot be empty if it is defined.");
            }
        }
        if (json.has("gasInput") || json.has("fluidOutput")) {
            JsonArray gasInput = GsonHelper.m_13885_((JsonObject)json, (String)"gasInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"gasInput") : GsonHelper.m_13930_((JsonObject)json, (String)"gasInput");
            gasInputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().deserialize((JsonElement)gasInput);
            fluidOutput = SerializerHelper.getFluidStack(json, "fluidOutput");
            hasGasToFluid = true;
            if (fluidOutput.isEmpty()) {
                throw new JsonSyntaxException("Rotary recipe fluid output cannot be empty if it is defined.");
            }
        }
        if (hasFluidToGas && hasGasToFluid) {
            return this.factory.create(recipeId, fluidInputIngredient, gasInputIngredient, gasOutput, fluidOutput);
        }
        if (hasFluidToGas) {
            return this.factory.create(recipeId, fluidInputIngredient, gasOutput);
        }
        if (hasGasToFluid) {
            return this.factory.create(recipeId, gasInputIngredient, fluidOutput);
        }
        throw new JsonSyntaxException("Rotary recipes require at least a gas to fluid or fluid to gas conversion.");
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            boolean hasGasToFluid;
            FluidStackIngredient fluidInputIngredient = null;
            ChemicalStackIngredient.GasStackIngredient gasInputIngredient = null;
            GasStack gasOutput = null;
            FluidStack fluidOutput = null;
            boolean hasFluidToGas = buffer.readBoolean();
            if (hasFluidToGas) {
                fluidInputIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
                gasOutput = GasStack.readFromPacket(buffer);
            }
            if (hasGasToFluid = buffer.readBoolean()) {
                gasInputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
                fluidOutput = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            }
            if (hasFluidToGas && hasGasToFluid) {
                return this.factory.create(recipeId, fluidInputIngredient, gasInputIngredient, gasOutput, fluidOutput);
            }
            if (hasFluidToGas) {
                return this.factory.create(recipeId, fluidInputIngredient, gasOutput);
            }
            if (hasGasToFluid) {
                return this.factory.create(recipeId, gasInputIngredient, fluidOutput);
            }
            Mekanism.logger.error("Error reading rotary recipe from packet. A recipe got sent with no conversion in either direction.");
            return null;
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading rotary recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        if (((RotaryRecipe)recipe).hasFluidToGas() || ((RotaryRecipe)recipe).hasGasToFluid()) {
            try {
                ((RotaryRecipe)recipe).write(buffer);
            }
            catch (Exception e) {
                Mekanism.logger.error("Error writing rotary recipe to packet.", (Throwable)e);
                throw e;
            }
        } else {
            Mekanism.logger.error("Error writing rotary recipe to packet. {} has no conversion in either direction, so was not sent.", recipe);
        }
    }

    public static interface IFactory<RECIPE extends RotaryRecipe> {
        public RECIPE create(ResourceLocation var1, FluidStackIngredient var2, GasStack var3);

        public RECIPE create(ResourceLocation var1, ChemicalStackIngredient.GasStackIngredient var2, FluidStack var3);

        public RECIPE create(ResourceLocation var1, FluidStackIngredient var2, ChemicalStackIngredient.GasStackIngredient var3, GasStack var4, FluidStack var5);
    }
}

