/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity.layer;

import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessedByLicowitch;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class LicowitchPossessionLayer<T extends LivingEntity, M extends AdvancedEntityModel<T>>
extends RenderLayer<T, M> {
    private AdvancedEntityModel<T> replacementModel;
    private Function<T, ResourceLocation> replacementTexture;

    public LicowitchPossessionLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public LicowitchPossessionLayer(RenderLayerParent<T, M> renderLayerParent, Function<T, ResourceLocation> replacementTexture) {
        super(renderLayerParent);
        this.replacementTexture = replacementTexture;
    }

    public LicowitchPossessionLayer(RenderLayerParent<T, M> renderLayerParent, AdvancedEntityModel<T> replacementModel, Function<T, ResourceLocation> replacementTexture) {
        super(renderLayerParent);
        this.replacementModel = replacementModel;
        this.replacementTexture = replacementTexture;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LicowitchEntity licowitch;
        if (((PossessedByLicowitch)entity).getPossessedByLicowitchId() != -1 && (licowitch = ((PossessedByLicowitch)entity).getPossessingLicowitch(entity.m_9236_())) != null) {
            AdvancedEntityModel<T> model = (AdvancedEntityModel<T>)this.m_117386_();
            ResourceLocation texture = this.m_117347_((Entity)entity);
            if (this.replacementTexture != null) {
                texture = this.replacementTexture.apply(entity);
            }
            if (this.replacementModel != null) {
                model = this.replacementModel;
                ((AdvancedEntityModel)this.m_117386_()).m_102624_(model);
                model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
            float possessAlpha = (float)((double)0.35f + (1.0 + Math.sin(ageInTicks * 0.2f)) * (double)0.15f);
            PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.PURPLE_WITCH_SHADER);
            model.m_7695_(poseStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)texture)), packedLightIn, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 0.3f, 1.0f, possessAlpha);
            model.m_7695_(poseStack, bufferIn.m_6299_(ACRenderTypes.getPurpleWitch(texture)), packedLightIn, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

