/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.QuarryBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.QuarryBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.QuarrySmasherHeadEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class QuarrySmasherEntity
extends Entity {
    public final QuarrySmasherHeadEntity headPart;
    public final QuarrySmasherHeadEntity[] allParts;
    public AABB lastMiningArea = null;
    private static final EntityDataAccessor<Boolean> INACTIVE = SynchedEntityData.m_135353_(QuarrySmasherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> QUARRY_POS = SynchedEntityData.m_135353_(QuarrySmasherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> TARGET_POS = SynchedEntityData.m_135353_(QuarrySmasherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> SLAMMING = SynchedEntityData.m_135353_(QuarrySmasherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PULLING_ITEMS_FOR = SynchedEntityData.m_135353_(QuarrySmasherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float inactiveProgress;
    private float prevInactiveProgress;
    private float headGroundProgress;
    private float prevHeadGroundProgress;
    private int damageSustained;
    private int quarryActivityTime = 0;
    private int blockBreakCooldown = 0;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    public int shakeTime = 0;
    public List<ItemEntity> pulledItems = new ArrayList<ItemEntity>();
    private boolean triggerAdvancement;

    public QuarrySmasherEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.headPart = new QuarrySmasherHeadEntity(this);
        this.allParts = new QuarrySmasherHeadEntity[]{this.headPart};
        this.headPart.m_20359_(this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(QUARRY_POS, Optional.empty());
        this.f_19804_.m_135372_(TARGET_POS, Optional.empty());
        this.f_19804_.m_135372_(INACTIVE, (Object)true);
        this.f_19804_.m_135372_(SLAMMING, (Object)false);
        this.f_19804_.m_135372_(PULLING_ITEMS_FOR, (Object)0);
    }

    public QuarrySmasherEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)ACEntityRegistry.QUARRY_SMASHER.get(), world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        this.tickMultipart();
        super.m_8119_();
        this.prevInactiveProgress = this.inactiveProgress;
        this.prevHeadGroundProgress = this.headGroundProgress;
        if (this.isInactive() && this.inactiveProgress < 10.0f) {
            this.inactiveProgress += 1.0f;
        }
        if (!this.isInactive() && this.inactiveProgress > 0.0f) {
            this.inactiveProgress -= 1.0f;
        }
        if (this.isSlamming() && this.headGroundProgress < 5.0f) {
            this.headGroundProgress += 1.0f;
        }
        if (!this.isSlamming() && this.headGroundProgress > 0.0f) {
            this.headGroundProgress -= 1.0f;
        }
        if (this.damageSustained > 0 && this.f_19797_ % 500 == 0) {
            --this.damageSustained;
        }
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
            if (this.m_6084_()) {
                AlexsCaves.PROXY.playWorldSound((Object)this, (byte)14);
            }
        } else if (this.triggerAdvancement && this.f_19797_ % 20 == 0) {
            boolean flag = false;
            double advancementRange = 20.0;
            for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(advancementRange))) {
                if (!((double)player.m_20270_((Entity)this) < advancementRange)) continue;
                flag = true;
                ACAdvancementTriggerRegistry.FINISHED_QUARRY.triggerForEntity((Entity)player);
            }
            boolean bl = this.triggerAdvancement = !flag;
        }
        if (this.isInactive()) {
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.2, 0.0));
            }
        } else {
            BlockPos quarryPos = this.getQuarryPos();
            if (this.quarryActivityTime-- < 0) {
                this.quarryActivityTime = 20;
                if (quarryPos == null || !this.m_9236_().m_8055_(quarryPos).m_60713_((Block)ACBlockRegistry.QUARRY.get())) {
                    this.setQuarryPos(null);
                    this.setInactive(true);
                } else {
                    BlockEntity d6 = this.m_9236_().m_7702_(quarryPos);
                    if (d6 instanceof QuarryBlockEntity) {
                        QuarryBlockEntity quarryBlockEntity = (QuarryBlockEntity)d6;
                        this.lastMiningArea = quarryBlockEntity.getMiningBox();
                    }
                }
            }
            BlockPos targetPos = this.getTargetPos();
            if (!this.m_9236_().f_46443_) {
                if (targetPos == null) {
                    this.setTargetPos(this.findTarget());
                } else {
                    Vec3 dist = Vec3.m_82514_((Vec3i)(quarryPos == null ? targetPos : targetPos.m_175288_(quarryPos.m_123342_())), (double)4.0).m_82546_(this.m_20182_());
                    if (dist.m_165924_() < 0.5) {
                        if (this.blockBreakCooldown <= 0) {
                            this.setSlamming(true);
                            if (this.headPart.m_20182_().m_82554_(Vec3.m_82539_((Vec3i)targetPos)) < 1.1) {
                                this.setSlamming(false);
                                this.m_9236_().m_5594_(null, targetPos, (SoundEvent)ACSoundRegistry.BOUNDROID_SLAM.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
                                this.m_9236_().m_46961_(targetPos, true);
                                this.setTargetPos(null);
                                this.blockBreakCooldown = 35;
                                this.setPullingItemsFor(20);
                            }
                        }
                    } else {
                        this.m_20256_(this.m_20184_().m_82549_(dist.m_82541_().m_82490_((double)0.1f)));
                    }
                }
            }
        }
        if (this.pullingItemsFor() > 0) {
            BlockEntity blockEntity;
            int i = this.pullingItemsFor() - 1;
            this.setPullingItemsFor(i);
            BlockPos quarry = this.getQuarryPos();
            boolean flag = false;
            for (ItemEntity itemEntity : this.m_9236_().m_45976_(ItemEntity.class, this.headPart.m_20191_().m_82377_(2.0, 4.0, 2.0))) {
                itemEntity.f_19812_ = true;
                if (!this.pulledItems.contains(itemEntity)) {
                    this.pulledItems.add(itemEntity);
                }
                flag = true;
            }
            for (ItemEntity itemEntity : this.pulledItems) {
                if (i == 0) {
                    if (quarry == null || !this.m_9236_().m_8055_(quarry).m_60713_((Block)ACBlockRegistry.QUARRY.get())) continue;
                    itemEntity.m_6034_((double)((float)quarry.m_123341_() + 0.5f), (double)((float)quarry.m_123342_() + 1.0f), (double)((float)quarry.m_123343_() + 0.5f));
                    Direction facing = (Direction)this.m_9236_().m_8055_(quarry).m_61143_((Property)QuarryBlock.FACING);
                    itemEntity.m_32060_();
                    itemEntity.m_20256_(new Vec3((double)((float)facing.m_122429_() * 0.1f), (double)0.4f, (double)((float)facing.m_122431_() * 0.1f)));
                    continue;
                }
                itemEntity.m_146884_(this.headPart.m_20182_().m_82492_(0.0, 0.5, 0.0));
                itemEntity.m_20256_(Vec3.f_82478_);
            }
            if (flag && quarry != null && (blockEntity = this.m_9236_().m_7702_(quarry)) instanceof QuarryBlockEntity) {
                QuarryBlockEntity quarryBlockEntity = (QuarryBlockEntity)blockEntity;
                quarryBlockEntity.spinFor = 13;
                this.m_9236_().m_5594_((Player)null, quarry, (SoundEvent)ACSoundRegistry.QUARRY_CRUSH.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.m_9236_().f_46441_.m_188501_() * 0.2f);
            }
            if (i == 0) {
                this.pulledItems.clear();
            }
        }
        if (this.blockBreakCooldown > 0) {
            --this.blockBreakCooldown;
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_((double)0.7f));
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lSteps > 0) {
            this.lSteps = 0;
            this.m_19890_(this.lx, this.ly, this.lz, (float)this.lyr, (float)this.lxr);
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public BlockPos findTarget() {
        QuarryBlockEntity quarryBlockEntity;
        BlockEntity blockEntity;
        BlockPos quarry = this.getQuarryPos();
        if (quarry != null && (blockEntity = this.m_9236_().m_7702_(quarry)) instanceof QuarryBlockEntity && (quarryBlockEntity = (QuarryBlockEntity)blockEntity).hasMiningArea()) {
            BlockPos pos = quarryBlockEntity.findMinableBlock(this.m_9236_(), quarry.m_123342_() + 3).orElse(null);
            if (pos != null) {
                return pos;
            }
            this.triggerAdvancement = true;
        }
        return null;
    }

    public void tickMultipart() {
        Vec3 headTarget = this.getHeadTargetPos();
        float fallSpeed = 0.05f;
        if (this.isInactive()) {
            fallSpeed = 0.5f;
        } else if (this.isSlamming()) {
            fallSpeed = this.getHeadGroundProgress(1.0f) * 0.3f;
        } else if (this.pullingItemsFor() > 5) {
            fallSpeed = 0.0f;
        }
        Vec3 moveHeadBy = headTarget.m_82546_(this.headPart.m_20182_()).m_82490_((double)fallSpeed);
        if (this.f_19797_ > 1) {
            this.headPart.m_146867_();
            this.headPart.m_146884_(moveHeadBy.m_82549_(this.headPart.m_20182_()));
        } else {
            this.headPart.m_146884_(this.m_20182_());
            this.headPart.m_146867_();
        }
    }

    private Vec3 getHeadTargetPos() {
        BlockPos target;
        if (this.isInactive()) {
            return this.m_20182_().m_82520_(0.75, 0.0, -0.75);
        }
        if (this.isSlamming() && (target = this.getTargetPos()) != null) {
            return Vec3.m_82514_((Vec3i)target, (double)1.0);
        }
        return this.m_20182_().m_82520_(0.0, -1.0 + Math.sin((double)this.f_19797_ * 0.1) * 0.5, 0.0);
    }

    public float getChainLength(float partialTick) {
        return this.headPart == null ? 0.0f : (float)this.headPart.m_20318_(partialTick).m_82546_(this.m_20318_(partialTick)).m_82553_();
    }

    public boolean isInactive() {
        return (Boolean)this.f_19804_.m_135370_(INACTIVE);
    }

    public void setInactive(boolean inactive) {
        this.f_19804_.m_135381_(INACTIVE, (Object)inactive);
    }

    public boolean isSlamming() {
        return (Boolean)this.f_19804_.m_135370_(SLAMMING);
    }

    public void setSlamming(boolean slamming) {
        this.f_19804_.m_135381_(SLAMMING, (Object)slamming);
    }

    public int pullingItemsFor() {
        return (Integer)this.f_19804_.m_135370_(PULLING_ITEMS_FOR);
    }

    public void setPullingItemsFor(int pullingItemsFor) {
        this.f_19804_.m_135381_(PULLING_ITEMS_FOR, (Object)pullingItemsFor);
    }

    public float getInactiveProgress(float partialTick) {
        return (this.prevInactiveProgress + (this.inactiveProgress - this.prevInactiveProgress) * partialTick) * 0.1f;
    }

    public boolean isBeingActivated() {
        return this.inactiveProgress <= this.prevInactiveProgress;
    }

    public float getHeadGroundProgress(float partialTick) {
        return (this.prevHeadGroundProgress + (this.headGroundProgress - this.prevHeadGroundProgress) * partialTick) * 0.2f;
    }

    public void setQuarryPos(@Nullable BlockPos pos) {
        this.m_20088_().m_135381_(QUARRY_POS, Optional.ofNullable(pos));
    }

    @Nullable
    public BlockPos getQuarryPos() {
        return ((Optional)this.m_20088_().m_135370_(QUARRY_POS)).orElse(null);
    }

    public void setTargetPos(@Nullable BlockPos pos) {
        this.m_20088_().m_135381_(TARGET_POS, Optional.ofNullable(pos));
    }

    @Nullable
    public BlockPos getTargetPos() {
        return ((Optional)this.m_20088_().m_135370_(TARGET_POS)).orElse(null);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public void m_7822_(byte b) {
        if (b == 48) {
            this.shakeTime = 10;
        } else {
            super.m_7822_(b);
        }
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6097_() {
        return !this.m_213877_();
    }

    public boolean m_142391_() {
        return !this.m_213877_();
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ACItemRegistry.QUARRY_SMASHER.get());
    }

    protected void m_7378_(CompoundTag tag) {
    }

    protected void m_7380_(CompoundTag tag) {
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor(this);
        super.m_142687_(removalReason);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public boolean m_6469_(DamageSource damageSource, float damageValue) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        this.damageSustained = (int)((float)this.damageSustained + damageValue);
        this.m_9236_().m_7605_((Entity)this, (byte)48);
        if (this.damageSustained >= 10) {
            this.m_216990_(SoundEvents.f_12018_);
            if (!this.m_213877_()) {
                int i;
                for (i = 0; i < 1 + this.f_19796_.m_188503_(1); ++i) {
                    this.m_19998_((ItemLike)ACItemRegistry.AZURE_NEODYMIUM_INGOT.get());
                }
                for (i = 0; i < 1 + this.f_19796_.m_188503_(1); ++i) {
                    this.m_19998_((ItemLike)ACItemRegistry.SCARLET_NEODYMIUM_INGOT.get());
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return true;
    }
}

