/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.PewenBranchBlock;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityDataRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.GroundPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.ai.GummyBearBackScratchGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GummyBearMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SweetishFishEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.GummyColors;
import com.github.alexmodguy.alexscaves.server.entity.util.HasGummyColors;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessedByLicowitch;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.IDancesToJukebox;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class GummyBearEntity
extends Animal
implements IDancesToJukebox,
IAnimatedEntity,
PossessedByLicowitch,
HasGummyColors {
    private static final EntityDataAccessor<GummyColors> GUMMY_COLOR = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)((EntityDataSerializer)ACEntityDataRegistry.GUMMY_COLOR.get()));
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIGESTING = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> STOMACH_RED = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> STOMACH_GREEN = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> STOMACH_BLUE = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> HELD_MOB_ID = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> POSSESSOR_LICOWITCH_ID = SynchedEntityData.m_135353_(GummyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Animation ANIMATION_FISH = Animation.create((int)35);
    public static final Animation ANIMATION_EAT = Animation.create((int)40);
    public static final Animation ANIMATION_BACKSCRATCH = Animation.create((int)90);
    public static final Animation ANIMATION_MAUL = Animation.create((int)25);
    public static final Animation ANIMATION_SWIPE = Animation.create((int)25);
    private Animation currentAnimation;
    private int animationTick;
    private float prevSitProgress;
    private float sitProgress;
    private float prevStandProgress;
    private float standProgress;
    public float prevDanceProgress;
    public float danceProgress;
    public float prevSleepProgress;
    public float sleepProgress;
    public float prevStomachAlpha;
    public float stomachAlpha;
    public BlockPos jukeboxPosition;
    public boolean lookForTheGummyBearAlbumInStoresOnNovember13th = GummyBearEntity.checkNovember13th();
    private ResourceLocation digestingEffect;
    private int standFor = 0;
    private int sitFor = 0;
    private int sleepFor = 0;
    private int jellybeansToMake = 5;

    public GummyBearEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GUMMY_COLOR, (Object)GummyColors.RED);
        this.f_19804_.m_135372_(DANCING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(STANDING, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(DIGESTING, (Object)false);
        this.f_19804_.m_135372_(STOMACH_RED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STOMACH_GREEN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STOMACH_BLUE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HELD_MOB_ID, (Object)-1);
        this.f_19804_.m_135372_(POSSESSOR_LICOWITCH_ID, (Object)-1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 36.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    public static boolean checkGummyBearSpawnRules(EntityType<? extends Animal> type, LevelAccessor levelAccessor, MobSpawnType mobType, BlockPos pos, RandomSource randomSource) {
        return levelAccessor.m_8055_(pos.m_7495_()).m_60713_((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get()) && levelAccessor.m_6425_(pos).m_76178_() && levelAccessor.m_6425_(pos.m_7495_()).m_76178_();
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        return levelReader.m_8055_(pos.m_7495_()).m_60713_((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get()) ? 10.0f : super.m_5610_(pos, levelReader);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigatorNoSpin((Mob)this, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitGoal());
        this.f_21345_.m_25352_(2, (Goal)new GummyBearMeleeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.0){

            public boolean m_202729_() {
                return GummyBearEntity.this.m_6162_() && super.m_202729_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new GummyBearBackScratchGoal(this, 20));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42589_}), false));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f){

            public boolean m_8036_() {
                return !GummyBearEntity.this.stopRotating() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return !GummyBearEntity.this.stopRotating() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SweetishFishEntity.class, 100, true, false, livingEntity -> {
            SweetishFishEntity sweetishFish;
            return livingEntity instanceof SweetishFishEntity && (sweetishFish = (SweetishFishEntity)livingEntity).getGummyColor() == this.getGummyColor();
        }));
        this.f_21346_.m_25352_(3, (Goal)new ProtectBabiesGoal());
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true, false));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("GummyColor", this.getGummyColor().ordinal());
        if (this.digestingEffect != null) {
            compound.m_128359_("DigestingEffect", this.digestingEffect.toString());
        }
        compound.m_128379_("BearSleeping", this.isBearSleeping());
        compound.m_128379_("BearSitting", this.isSitting());
        compound.m_128405_("SleepTime", this.sleepFor);
        compound.m_128405_("SitTime", this.sitFor);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setGummyColor(GummyColors.fromOrdinal(compound.m_128451_("GummyColor")));
        if (compound.m_128441_("DigestingEffect")) {
            this.digestingEffect = new ResourceLocation(compound.m_128461_("DigestingEffect"));
        }
        this.setBearSleeping(compound.m_128471_("BearSleeping"));
        this.setStanding(compound.m_128471_("BearSitting"));
        this.sleepFor = compound.m_128451_("SleepTime");
        this.sitFor = compound.m_128451_("SitTime");
    }

    public boolean m_6898_(ItemStack itemStack) {
        Item fishItem = (Item)ACItemRegistry.SWEETISH_FISH_RED.get();
        switch (this.getGummyColor()) {
            case GREEN: {
                fishItem = (Item)ACItemRegistry.SWEETISH_FISH_GREEN.get();
                break;
            }
            case BLUE: {
                fishItem = (Item)ACItemRegistry.SWEETISH_FISH_BLUE.get();
                break;
            }
            case YELLOW: {
                fishItem = (Item)ACItemRegistry.SWEETISH_FISH_YELLOW.get();
                break;
            }
            case PINK: {
                fishItem = (Item)ACItemRegistry.SWEETISH_FISH_PINK.get();
            }
        }
        return itemStack.m_150930_(fishItem);
    }

    @Override
    public GummyColors getGummyColor() {
        return (GummyColors)((Object)this.f_19804_.m_135370_(GUMMY_COLOR));
    }

    public void setGummyColor(GummyColors color) {
        this.f_19804_.m_135381_(GUMMY_COLOR, (Object)color);
    }

    public float getStomachRed() {
        return ((Float)this.f_19804_.m_135370_(STOMACH_RED)).floatValue();
    }

    public void setStomachRed(float stomachRed) {
        this.f_19804_.m_135381_(STOMACH_RED, (Object)Float.valueOf(stomachRed));
    }

    public float getStomachGreen() {
        return ((Float)this.f_19804_.m_135370_(STOMACH_GREEN)).floatValue();
    }

    public void setStomachGreen(float stomachGreen) {
        this.f_19804_.m_135381_(STOMACH_GREEN, (Object)Float.valueOf(stomachGreen));
    }

    public float getStomachBlue() {
        return ((Float)this.f_19804_.m_135370_(STOMACH_BLUE)).floatValue();
    }

    public void setStomachBlue(float stomachBlue) {
        this.f_19804_.m_135381_(STOMACH_BLUE, (Object)Float.valueOf(stomachBlue));
    }

    public float getStomachAlpha(float partialTicks) {
        return this.prevStomachAlpha + (this.stomachAlpha - this.prevStomachAlpha) * partialTicks;
    }

    @Override
    public void setPossessedByLicowitchId(int entityId) {
        this.f_19804_.m_135381_(POSSESSOR_LICOWITCH_ID, (Object)entityId);
    }

    @Override
    public int getPossessedByLicowitchId() {
        return (Integer)this.f_19804_.m_135370_(POSSESSOR_LICOWITCH_ID);
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.getPossessedByLicowitchId() == -1;
    }

    public boolean m_6779_(LivingEntity living) {
        LicowitchEntity licowitch;
        if (this.getPossessedByLicowitchId() != -1 && (licowitch = this.getPossessingLicowitch(this.m_9236_())) != null && licowitch.isFriendlyFire(living)) {
            return false;
        }
        return super.m_6779_(living);
    }

    public boolean digestEffect(Potion potion) {
        this.digestingEffect = ForgeRegistries.POTIONS.getKey((Object)potion);
        this.updateDigestionColors();
        return true;
    }

    private void updateDigestionColors() {
        int colorizer;
        Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(this.digestingEffect);
        if (potion != null && (colorizer = PotionUtils.m_43559_((Potion)potion)) != -1) {
            float f = (float)(colorizer >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(colorizer >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(colorizer & 0xFF) / 255.0f;
            this.setStomachRed(f);
            this.setStomachGreen(f1);
            this.setStomachBlue(f2);
        }
    }

    public boolean isDigestiblePotion(ItemStack itemStack) {
        if (itemStack.m_150930_(Items.f_42589_)) {
            Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
            return !potion.m_43491_() && !potion.m_43488_().isEmpty();
        }
        return false;
    }

    public ItemStack createJellybean() {
        Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(this.digestingEffect);
        return potion == null ? new ItemStack((ItemLike)ACItemRegistry.JELLY_BEAN.get()) : ACEffectRegistry.createJellybean(potion);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(0.25f);
        }
        this.setGummyColor(GummyColors.getRandom(this.f_19796_, true));
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageableMob) {
        GummyBearEntity gummyBear = (GummyBearEntity)((EntityType)ACEntityRegistry.GUMMY_BEAR.get()).m_20615_((Level)level);
        gummyBear.setGummyColor(this.getGummyColor());
        return gummyBear;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        boolean flag = this.currentAnimation != animation;
        this.currentAnimation = animation;
        if (this.isSittingAnimation() && flag) {
            this.sitFor += animation.getDuration();
        }
        if (this.isStandingAnimation() && flag) {
            this.standFor += animation.getDuration();
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_FISH, ANIMATION_EAT, ANIMATION_BACKSCRATCH, ANIMATION_MAUL, ANIMATION_SWIPE};
    }

    private static boolean checkNovember13th() {
        LocalDate localdate = LocalDate.now();
        int i = localdate.get(ChronoField.DAY_OF_MONTH);
        int j = localdate.get(ChronoField.MONTH_OF_YEAR);
        return j == 11 && i > 12 && i < 15;
    }

    public float getSitProgress(float partialTicks) {
        return (this.prevSitProgress + (this.sitProgress - this.prevSitProgress) * partialTicks) * 0.1f;
    }

    public float getStandProgress(float partialTicks) {
        return (this.prevStandProgress + (this.standProgress - this.prevStandProgress) * partialTicks) * 0.1f;
    }

    public float getDanceProgress(float partialTicks) {
        return (this.prevDanceProgress + (this.danceProgress - this.prevDanceProgress) * partialTicks) * 0.2f;
    }

    public float getSleepProgress(float partialTicks) {
        return (this.prevSleepProgress + (this.sleepProgress - this.prevSleepProgress) * partialTicks) * 0.1f;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevDanceProgress = this.danceProgress;
        this.prevSitProgress = this.sitProgress;
        this.prevStandProgress = this.standProgress;
        this.prevSleepProgress = this.sleepProgress;
        this.prevStomachAlpha = this.stomachAlpha;
        if (this.jukeboxPosition == null || !this.jukeboxPosition.m_203195_((Position)this.m_20182_(), 15.0) || !this.m_9236_().m_8055_(this.jukeboxPosition).m_60713_(Blocks.f_50131_)) {
            this.setDancing(false);
            this.jukeboxPosition = null;
        }
        if (this.isDancing() && this.danceProgress < 5.0f) {
            this.danceProgress += 1.0f;
        }
        if (!this.isDancing() && this.danceProgress > 0.0f) {
            this.danceProgress -= 1.0f;
        }
        if (this.isSitting() && this.sitProgress < 10.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding() && this.standProgress < 10.0f) {
            this.standProgress += 1.0f;
        }
        if (!this.isStanding() && this.standProgress > 0.0f) {
            this.standProgress -= 1.0f;
        }
        if (this.isBearSleeping() && this.sleepProgress < 10.0f) {
            this.sleepProgress += 1.0f;
        }
        if (!this.isBearSleeping() && this.sleepProgress > 0.0f) {
            this.sleepProgress -= 1.0f;
        }
        if (this.isDigesting()) {
            this.stomachAlpha = Mth.m_14121_((float)this.stomachAlpha, (float)1.0f, (float)0.05f);
        } else {
            this.stomachAlpha = Mth.m_14121_((float)this.stomachAlpha, (float)0.0f, (float)0.05f);
            if (this.stomachAlpha <= 0.0f && this.digestingEffect != null) {
                this.digestingEffect = null;
            }
        }
        if (this.m_9236_().f_46443_) {
            int sleepDiv;
            if (this.isBearSleeping() && ((sleepDiv = this.f_19797_ % 50) == 2 || sleepDiv == 10 || sleepDiv == 18)) {
                Vec3 headPos = this.m_146892_().m_82549_(new Vec3((double)0.2f, (double)-0.4f, (double)1.2f).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)));
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.SLEEP.get(), headPos.f_82479_, headPos.f_82480_, headPos.f_82481_, 0.0, (double)0.1f, 0.0);
            }
            this.spawnPossessedParticles(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), this.m_9236_());
        } else {
            int animationDurationLeft;
            int n = animationDurationLeft = this.currentAnimation == null ? 0 : this.currentAnimation.getDuration() - this.getAnimationTick();
            if (this.isSittingAnimation() && this.sitFor < animationDurationLeft) {
                this.sitFor = animationDurationLeft;
            }
            if (this.isStandingAnimation() && this.standFor < animationDurationLeft) {
                this.standFor = animationDurationLeft;
            }
            if (this.sleepFor > 0) {
                this.setStanding(false);
                this.setSitting(false);
                this.setBearSleeping(true);
                --this.sleepFor;
            } else {
                this.setBearSleeping(false);
                if (this.sitFor > 0) {
                    --this.sitFor;
                    this.setSitting(true);
                } else {
                    this.setSitting(false);
                    if (this.standFor > 0) {
                        --this.standFor;
                        this.setStanding(true);
                    } else {
                        this.setStanding(false);
                    }
                }
            }
            if (this.getAnimation() == ANIMATION_BACKSCRATCH) {
                if (this.getAnimationTick() % 15 == 0 && this.getAnimationTick() > 0 && this.jellybeansToMake > 0) {
                    this.m_5552_(this.createJellybean(), 1.0f + this.f_19796_.m_188501_());
                    --this.jellybeansToMake;
                }
                if (this.jellybeansToMake <= 0 || this.getAnimationTick() > 85) {
                    this.setDigesting(false);
                }
            }
        }
        Entity heldMob = this.getHeldMob();
        if (heldMob != null && heldMob.m_6084_() && heldMob.m_20270_((Entity)this) < 10.0f) {
            Vec3 heldPos = this.m_146892_().m_82549_(new Vec3(0.0, 0.25, 0.5).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)));
            Vec3 minus = new Vec3(heldPos.f_82479_ - heldMob.m_20185_(), heldPos.f_82480_ - heldMob.m_20186_(), heldPos.f_82481_ - heldMob.m_20189_());
            heldMob.m_20256_(minus);
            heldMob.f_19789_ = 0.0f;
            heldMob.m_146922_(0.0f);
            heldMob.m_5618_(0.0f);
            heldMob.m_5616_(0.0f);
            heldMob.m_146926_(0.0f);
            heldMob.m_20301_(40);
            this.setAnimation(ANIMATION_EAT);
            if (this.f_19797_ % 15 == 0) {
                heldMob.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.f_19796_.m_188499_() ? 0.0f : 1.0f);
            }
        } else if (!this.m_9236_().f_46443_) {
            this.setHeldMobId(-1);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DANCING);
    }

    public void setDancing(boolean bool) {
        this.f_19804_.m_135381_(DANCING, (Object)bool);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean bool) {
        this.f_19804_.m_135381_(SITTING, (Object)bool);
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(STANDING);
    }

    public void setStanding(boolean bool) {
        this.f_19804_.m_135381_(STANDING, (Object)bool);
    }

    public boolean isBearSleeping() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setBearSleeping(boolean bool) {
        this.f_19804_.m_135381_(SLEEPING, (Object)bool);
    }

    public boolean isDigesting() {
        return (Boolean)this.f_19804_.m_135370_(DIGESTING);
    }

    public void setDigesting(boolean bool) {
        this.f_19804_.m_135381_(DIGESTING, (Object)bool);
    }

    public void setHeldMobId(int i) {
        this.f_19804_.m_135381_(HELD_MOB_ID, (Object)i);
    }

    public int getHeldMobId() {
        return (Integer)this.f_19804_.m_135370_(HELD_MOB_ID);
    }

    public Entity getHeldMob() {
        int id = this.getHeldMobId();
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public boolean isStandingAnimation() {
        return this.getAnimation() == ANIMATION_BACKSCRATCH || this.getAnimation() == ANIMATION_MAUL;
    }

    public boolean isSittingAnimation() {
        return this.getAnimation() == ANIMATION_EAT;
    }

    public void m_6818_(BlockPos pos, boolean playing) {
        this.onClientPlayMusicDisc(this.m_19879_(), pos, playing);
    }

    public void setJukeboxPos(BlockPos blockPos) {
        this.jukeboxPosition = blockPos;
    }

    public boolean isMovementBlocked() {
        return this.isSitting() || this.isBearSleeping() || this.getAnimation() == ANIMATION_BACKSCRATCH;
    }

    public boolean m_6094_() {
        return this.getHeldMobId() == -1;
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.isDancing() || this.isSitting() || this.isMovementBlocked()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    private boolean stopRotating() {
        return this.isBearSleeping() || this.getAnimation() == ANIMATION_BACKSCRATCH;
    }

    public BlockPos getStandAtTreePos(BlockPos target) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)target).m_82546_(this.m_20182_());
        float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
        BlockState state = this.m_9236_().m_8055_(target);
        Direction dir = Direction.m_122364_((double)f);
        if (state.m_60713_((Block)ACBlockRegistry.PEWEN_BRANCH.get())) {
            dir = Direction.m_122364_((double)((Integer)state.m_61143_((Property)PewenBranchBlock.ROTATION) * 45));
        }
        if (this.m_9236_().m_8055_(target.m_7495_()).m_60795_()) {
            target = target.m_121945_(dir);
        }
        return target.m_5484_(dir.m_122424_(), 1).m_175288_((int)this.m_20186_());
    }

    public boolean lockTreePosition(BlockPos target) {
        Vec3 vec31;
        Vec3 vec32;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)target).m_82546_(this.m_20182_());
        float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
        BlockState state = this.m_9236_().m_8055_(target);
        Direction dir = Direction.m_122364_((double)f);
        if (state.m_60713_((Block)ACBlockRegistry.PEWEN_BRANCH.get())) {
            dir = Direction.m_122364_((double)((Integer)state.m_61143_((Property)PewenBranchBlock.ROTATION) * 45));
        }
        float targetRot = Mth.m_14148_((float)this.m_146908_(), (float)(180.0f + dir.m_122435_()), (float)20.0f);
        this.m_146922_(targetRot);
        this.m_5616_(targetRot);
        this.f_20883_ = targetRot;
        if (this.m_9236_().m_8055_(target.m_7495_()).m_60795_()) {
            target = target.m_121945_(dir);
        }
        if ((vec32 = (vec31 = Vec3.m_82539_((Vec3i)target)).m_82546_(this.m_20182_())).m_82553_() > 1.0) {
            vec32 = vec32.m_82541_();
        }
        Vec3 delta = new Vec3(vec32.f_82479_ * 0.25, 0.0, vec32.f_82481_ * 0.25);
        this.m_20256_(this.m_20184_().m_82490_((double)0.9f).m_82549_(delta));
        return this.m_20275_(vec31.f_82479_, this.m_20186_(), vec31.f_82481_) < 4.0 && Mth.m_14145_((float)this.m_146908_(), (float)(180.0f + dir.m_122435_())) < 7.0f;
    }

    public boolean isSleepy() {
        return this.sleepFor > 0;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isDigestiblePotion(itemstack) && !this.isDigesting()) {
            this.setDigesting(true);
            this.digestEffect(PotionUtils.m_43579_((ItemStack)itemstack));
            this.m_142075_(player, hand, itemstack);
            if (!player.m_150110_().f_35937_) {
                player.m_36356_(new ItemStack((ItemLike)Items.f_42590_));
            }
            this.sleepFor = 24000 * (2 + this.f_19796_.m_188503_(2));
            this.jellybeansToMake = this.f_19796_.m_188503_(2) + 3;
            this.m_5496_((SoundEvent)ACSoundRegistry.GUMMY_BEAR_EAT.get(), this.m_6121_(), this.m_6100_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != MobEffects.f_19612_;
    }

    public int m_8100_() {
        return this.isBearSleeping() ? 45 : 80;
    }

    protected SoundEvent m_7515_() {
        return this.isBearSleeping() ? (SoundEvent)ACSoundRegistry.GUMMY_BEAR_SNORE.get() : (SoundEvent)ACSoundRegistry.GUMMY_BEAR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.GUMMY_BEAR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.GUMMY_BEAR_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.m_6162_()) {
            this.m_5496_((SoundEvent)ACSoundRegistry.GUMMY_BEAR_STEP.get(), 0.3f, this.m_6100_());
        }
    }

    private class SitGoal
    extends Goal {
        public SitGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            return GummyBearEntity.this.isMovementBlocked();
        }

        public boolean m_8036_() {
            if (GummyBearEntity.this.m_20072_()) {
                return false;
            }
            return GummyBearEntity.this.isMovementBlocked();
        }

        public void m_8056_() {
            GummyBearEntity.this.m_21573_().m_26573_();
        }
    }

    private class ProtectBabiesGoal
    extends NearestAttackableTargetGoal<Player> {
        public ProtectBabiesGoal() {
            super((Mob)GummyBearEntity.this, Player.class, 20, true, true, (Predicate)null);
        }

        public boolean m_8036_() {
            if (GummyBearEntity.this.m_6162_()) {
                return false;
            }
            if (super.m_8036_()) {
                for (GummyBearEntity bear : GummyBearEntity.this.m_9236_().m_45976_(GummyBearEntity.class, GummyBearEntity.this.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                    if (!bear.m_6162_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }
}

