/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.biome;

import com.github.alexmodguy.alexscaves.server.level.biome.BiomeSampler;
import com.github.alexthe666.citadel.server.world.ExpandedBiomes;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.phys.Vec3;

public class ACBiomeRegistry {
    public static final ResourceKey<Biome> MAGNETIC_CAVES = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("alexscaves", "magnetic_caves"));
    public static final ResourceKey<Biome> PRIMORDIAL_CAVES = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("alexscaves", "primordial_caves"));
    public static final ResourceKey<Biome> TOXIC_CAVES = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("alexscaves", "toxic_caves"));
    public static final ResourceKey<Biome> ABYSSAL_CHASM = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("alexscaves", "abyssal_chasm"));
    public static final ResourceKey<Biome> FORLORN_HOLLOWS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("alexscaves", "forlorn_hollows"));
    public static final ResourceKey<Biome> CANDY_CAVITY = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("alexscaves", "candy_cavity"));
    public static final List<ResourceKey<Biome>> ALEXS_CAVES_BIOMES = List.of(MAGNETIC_CAVES, PRIMORDIAL_CAVES, TOXIC_CAVES, ABYSSAL_CHASM, FORLORN_HOLLOWS, CANDY_CAVITY);
    private static final Vec3 DEFAULT_LIGHT_COLOR = new Vec3(1.0, 1.0, 1.0);
    private static final Vec3 TOXIC_CAVES_LIGHT_COLOR = new Vec3(0.5, 1.5, 0.5);
    private static final Vec3 ABYSSAL_CHASM_LIGHT_COLOR = new Vec3(0.5, 0.5, 1.0);
    private static final Vec3 FORLORN_HOLLOWS_LIGHT_COLOR = new Vec3(0.35, 0.32, 0.3);
    private static final Vec3 CANDY_CAVITY_LIGHT_COLOR = new Vec3(1.1, 0.9, 1.0);

    public static void init() {
        ExpandedBiomes.addExpandedBiome(MAGNETIC_CAVES, (ResourceKey)LevelStem.f_63971_);
        ExpandedBiomes.addExpandedBiome(PRIMORDIAL_CAVES, (ResourceKey)LevelStem.f_63971_);
        ExpandedBiomes.addExpandedBiome(TOXIC_CAVES, (ResourceKey)LevelStem.f_63971_);
        ExpandedBiomes.addExpandedBiome(ABYSSAL_CHASM, (ResourceKey)LevelStem.f_63971_);
        ExpandedBiomes.addExpandedBiome(FORLORN_HOLLOWS, (ResourceKey)LevelStem.f_63971_);
        ExpandedBiomes.addExpandedBiome(CANDY_CAVITY, (ResourceKey)LevelStem.f_63971_);
    }

    public static float getBiomeAmbientLight(Holder<Biome> value) {
        if (value.m_203565_(PRIMORDIAL_CAVES)) {
            return 0.125f;
        }
        if (value.m_203565_(TOXIC_CAVES)) {
            return 0.01f;
        }
        if (value.m_203565_(CANDY_CAVITY)) {
            return 0.125f;
        }
        return 0.0f;
    }

    public static float getBiomeFogNearness(Holder<Biome> value) {
        if (value.m_203565_(PRIMORDIAL_CAVES)) {
            return 0.5f;
        }
        if (value.m_203565_(TOXIC_CAVES)) {
            return -0.15f;
        }
        if (value.m_203565_(ABYSSAL_CHASM)) {
            return -0.3f;
        }
        if (value.m_203565_(FORLORN_HOLLOWS)) {
            return -0.2f;
        }
        if (value.m_203565_(CANDY_CAVITY)) {
            return 0.75f;
        }
        return 1.0f;
    }

    public static float getBiomeWaterFogFarness(Holder<Biome> value) {
        if (value.m_203565_(ABYSSAL_CHASM)) {
            return 0.5f;
        }
        return 1.0f;
    }

    public static float getBiomeSkyOverride(Holder<Biome> value) {
        if (value.m_203565_(MAGNETIC_CAVES) || value.m_203565_(PRIMORDIAL_CAVES) || value.m_203565_(TOXIC_CAVES) || value.m_203565_(ABYSSAL_CHASM) || value.m_203565_(FORLORN_HOLLOWS) || value.m_203565_(CANDY_CAVITY)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static Vec3 getBiomeLightColorOverride(Holder<Biome> value) {
        if (value.m_203565_(TOXIC_CAVES)) {
            return TOXIC_CAVES_LIGHT_COLOR;
        }
        if (value.m_203565_(ABYSSAL_CHASM)) {
            return ABYSSAL_CHASM_LIGHT_COLOR;
        }
        if (value.m_203565_(FORLORN_HOLLOWS)) {
            return FORLORN_HOLLOWS_LIGHT_COLOR;
        }
        if (value.m_203565_(CANDY_CAVITY)) {
            return CANDY_CAVITY_LIGHT_COLOR;
        }
        return DEFAULT_LIGHT_COLOR;
    }

    public static int getBiomeTabletColor(ResourceKey<Biome> value) {
        if (value.equals(MAGNETIC_CAVES)) {
            return 3744839;
        }
        if (value.equals(PRIMORDIAL_CAVES)) {
            return 16562688;
        }
        if (value.equals(TOXIC_CAVES)) {
            return 6998532;
        }
        if (value.equals(ABYSSAL_CHASM)) {
            return 1644972;
        }
        if (value.equals(FORLORN_HOLLOWS)) {
            return 7362098;
        }
        if (value.equals(CANDY_CAVITY)) {
            return 16735168;
        }
        return -1;
    }

    public static float calculateBiomeSkyOverride(Entity player) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        if (i == 0) {
            return ACBiomeRegistry.getBiomeSkyOverride((Holder<Biome>)player.m_9236_().m_204166_(player.m_20183_()));
        }
        return BiomeSampler.sampleBiomesFloat((LevelReader)player.m_9236_(), player.m_20182_(), ACBiomeRegistry::getBiomeSkyOverride);
    }
}

