/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.util.NotNullByDefault;
import snownee.kiwi.util.VoxelUtil;

@NotNullByDefault
public class PlaceDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private static final PlaceDebugRenderer INSTANCE = new PlaceDebugRenderer();
    private List<SlotRenderInstance> slots = List.of();
    private long lastUpdateTime;

    public static PlaceDebugRenderer getInstance() {
        return INSTANCE;
    }

    public void m_7790_(PoseStack pPoseStack, MultiBufferSource pBuffer, double pCamX, double pCamY, double pCamZ) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        long millis = Util.m_137550_();
        if (millis - this.lastUpdateTime > 300L) {
            this.lastUpdateTime = millis;
            Entity entity = mc.f_91063_.m_109153_().m_90592_();
            Level level = entity.m_9236_();
            this.slots = BlockPos.m_121921_((AABB)entity.m_20191_().m_82400_(4.0)).map(BlockPos::m_7949_).flatMap(pos -> {
                BlockState blockState = level.m_8055_(pos);
                return Direction.m_235666_().flatMap(side -> PlaceSlot.find(blockState, side).stream().map(slot -> SlotRenderInstance.create(slot, pos, side)));
            }).toList();
        }
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110504_());
        for (SlotRenderInstance instance : this.slots) {
            float r = (float)(instance.color >> 16 & 0xFF) / 255.0f;
            float g = (float)(instance.color >> 8 & 0xFF) / 255.0f;
            float b = (float)(instance.color & 0xFF) / 255.0f;
            LevelRenderer.m_285900_((PoseStack)pPoseStack, (VertexConsumer)vertexconsumer, (VoxelShape)instance.shape, (double)((double)instance.pos.m_123341_() - pCamX), (double)((double)instance.pos.m_123342_() - pCamY), (double)((double)instance.pos.m_123343_() - pCamZ), (float)r, (float)g, (float)b, (float)1.0f, (boolean)true);
        }
    }

    private record SlotRenderInstance(PlaceSlot slot, BlockPos pos, Direction side, VoxelShape shape, int color) {
        private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)6.0, (double)-0.5, (double)6.0, (double)10.0, (double)0.5, (double)10.0);
        private static final VoxelShape[] SHAPES = (VoxelShape[])Direction.m_235666_().map(side -> VoxelUtil.rotate(SHAPE_DOWN, side)).toArray(VoxelShape[]::new);

        private static SlotRenderInstance create(PlaceSlot slot, BlockPos pos, Direction side) {
            String tag = slot.primaryTag();
            int color = 0xFFFFFF;
            if (tag.endsWith("side")) {
                color = 0xFFAAAA;
            } else if (tag.endsWith("front") || tag.endsWith("top")) {
                color = 0xAAFFAA;
            } else if (tag.endsWith("back") || tag.endsWith("bottom")) {
                color = 0xAAAAFF;
            }
            return new SlotRenderInstance(slot, pos, side, SHAPES[side.ordinal()], color);
        }
    }
}

