/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.nutrients;

import com.github.elenterius.biomancy.api.nutrients.FuelHandler;
import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.api.nutrients.fluid.FluidFuelConsumerHandler;
import com.github.elenterius.biomancy.inventory.Notify;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FuelHandlerImpl
implements FuelHandler,
INBTSerializable<CompoundTag> {
    private final int maxFuel;
    private final Predicate<ItemStack> fuelPredicate;
    private final ToIntFunction<ItemStack> fuelValueFunc;
    private final Notify changeNotifier;
    private int fuel;
    private final FluidFuelConsumerHandler fluidConsumer;

    public FuelHandlerImpl(int maxFuel, Predicate<ItemStack> fuelPredicate, ToIntFunction<ItemStack> fuelValueFunc, Notify changeNotifier) {
        this.maxFuel = maxFuel;
        this.fuelPredicate = fuelPredicate;
        this.fuelValueFunc = fuelValueFunc;
        this.changeNotifier = changeNotifier;
        this.fluidConsumer = new FluidFuelConsumerHandler(this);
    }

    public static FuelHandlerImpl createNutrientFuelHandler(int maxFuel, Notify changeNotifier) {
        return new FuelHandlerImpl(maxFuel, Nutrients::isValidFuel, Nutrients::getFuelValue, changeNotifier);
    }

    @Override
    public int getFuelAmount() {
        return this.fuel;
    }

    @Override
    public void setFuelAmount(int amount) {
        boolean flag = amount != this.fuel;
        this.fuel = amount;
        if (flag) {
            this.setChanged();
        }
    }

    @Override
    public int getMaxFuelAmount() {
        return this.maxFuel;
    }

    @Override
    public void addFuelAmount(int amount) {
        this.setFuelAmount(Mth.m_14045_((int)(this.fuel + amount), (int)0, (int)this.maxFuel));
    }

    @Override
    public boolean isValidFuel(ItemStack stack) {
        return this.fuelPredicate.test(stack);
    }

    @Override
    public int getFuelCost(int craftingCostNutrients) {
        return craftingCostNutrients;
    }

    @Override
    public int getFuelValue(ItemStack stack) {
        return this.fuelValueFunc.applyAsInt(stack);
    }

    public void setChanged() {
        this.changeNotifier.invoke();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Amount", this.fuel);
        tag.m_128365_("FluidConsumer", (Tag)this.fluidConsumer.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.fuel = tag.m_128451_("Amount");
        this.fluidConsumer.deserializeNBT(tag.m_128469_("FluidConsumer"));
    }

    public IFluidHandler getFluidConsumer() {
        return this.fluidConsumer;
    }
}

