/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.serum;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface Serum {
    public static final String DATA_TAG_KEY = "serum_data";
    public static final String TRANSLATION_PREFIX = "serum.";
    public static final Serum EMPTY = new Serum(){

        @Override
        public boolean canAffectEntity(CompoundTag tag, @Nullable LivingEntity source, LivingEntity target) {
            return false;
        }

        @Override
        public void affectEntity(ServerLevel level, CompoundTag nbt, @Nullable LivingEntity source, LivingEntity target) {
        }

        @Override
        public boolean canAffectPlayerSelf(CompoundTag tag, Player targetSelf) {
            return false;
        }

        @Override
        public void affectPlayerSelf(CompoundTag nbt, ServerPlayer targetSelf) {
        }

        @Override
        public void appendTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getColor() {
            return -1;
        }

        @Override
        public String getNameTranslationKey() {
            return "serum.biomancy.empty";
        }
    };

    public static CompoundTag getDataTag(ItemStack stack) {
        return stack.m_41784_().m_128469_(DATA_TAG_KEY);
    }

    public static String makeTranslationKey(ResourceLocation key) {
        return TRANSLATION_PREFIX + key.m_135827_() + "." + key.m_135815_().replace("/", ".");
    }

    public static void removeDataTag(CompoundTag tag) {
        tag.m_128473_(DATA_TAG_KEY);
    }

    public static void copyDataTag(CompoundTag fromTag, CompoundTag toTag) {
        CompoundTag data;
        if (fromTag.m_128441_(DATA_TAG_KEY) && !(data = fromTag.m_128469_(DATA_TAG_KEY)).m_128456_()) {
            toTag.m_128365_(DATA_TAG_KEY, (Tag)data.m_6426_());
        }
    }

    public boolean canAffectEntity(CompoundTag var1, @Nullable LivingEntity var2, LivingEntity var3);

    public void affectEntity(ServerLevel var1, CompoundTag var2, @Nullable LivingEntity var3, LivingEntity var4);

    public boolean canAffectPlayerSelf(CompoundTag var1, Player var2);

    public void affectPlayerSelf(CompoundTag var1, ServerPlayer var2);

    default public boolean isEmpty() {
        return false;
    }

    public int getColor();

    public void appendTooltip(ItemStack var1, @Nullable Level var2, List<Component> var3, TooltipFlag var4);

    public String getNameTranslationKey();

    default public String getDescriptionTranslationKey() {
        return this.getNameTranslationKey() + ".tooltip";
    }

    default public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.getNameTranslationKey());
    }
}

