/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.tribute.fluid;

import com.github.elenterius.biomancy.api.tribute.Tribute;
import com.github.elenterius.biomancy.util.SaturatedMath;

public record FluidTribute(int biomass, int lifeEnergy, int successModifier, int diseaseModifier, int hostileModifier, int anomalyModifier) implements Tribute
{
    public static final long UNIT_SCALE = 1000L;

    public static FluidTribute of(Tribute tribute) {
        return FluidTribute.of(tribute, 1);
    }

    public static FluidTribute of(Tribute tribute, int ratio) {
        if (tribute instanceof FluidTribute) {
            FluidTribute fluidTribute = (FluidTribute)tribute;
            return fluidTribute;
        }
        return new FluidTribute(SaturatedMath.castToInteger((long)tribute.biomass() * 1000L / (long)ratio), SaturatedMath.castToInteger((long)tribute.lifeEnergy() * 1000L / (long)ratio), SaturatedMath.castToInteger((long)tribute.successModifier() * 1000L / (long)ratio), SaturatedMath.castToInteger((long)tribute.diseaseModifier() * 1000L / (long)ratio), SaturatedMath.castToInteger((long)tribute.hostileModifier() * 1000L / (long)ratio), SaturatedMath.castToInteger((long)tribute.anomalyModifier() * 1000L / (long)ratio));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int biomass = 0;
        private int lifeEnergy = 0;
        private int successModifier = 0;
        private int diseaseModifier = 0;
        private int hostileModifier = 0;
        private int anomalyModifier = 0;

        private Builder() {
        }

        public Builder successModifier(int successModifier) {
            this.successModifier = successModifier;
            return this;
        }

        public Builder diseaseModifier(int diseaseModifier) {
            this.diseaseModifier = diseaseModifier;
            return this;
        }

        public Builder hostileModifier(int hostileModifier) {
            this.hostileModifier = hostileModifier;
            return this;
        }

        public Builder biomass(int biomass) {
            this.biomass = biomass;
            return this;
        }

        public Builder lifeEnergy(int lifeEnergy) {
            this.lifeEnergy = lifeEnergy;
            return this;
        }

        public Builder anomalyModifier(int anomalyModifier) {
            this.anomalyModifier = anomalyModifier;
            return this;
        }

        public FluidTribute build() {
            return new FluidTribute(this.biomass, this.lifeEnergy, this.successModifier, this.diseaseModifier, this.hostileModifier, this.anomalyModifier);
        }
    }
}

