/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block;

import com.github.elenterius.biomancy.block.property.Orientation;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.init.ModBlockSetTypes;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FleshDoorBlock
extends DoorBlock {
    public static final EnumProperty<Orientation> ORIENTATION = ModBlockProperties.ORIENTATION;
    public static final int USE_UPDATE_FLAG = 10;
    protected static final int THICKNESS = 2;
    protected static final int CLOSED_SHAPE_INDEX = 0;
    protected static final int OPEN_SHAPE_INDEX = 1;
    protected static final VoxelShape[] x_NEG_AABB = FleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 2.0, 16.0, 16.0);
    protected static final VoxelShape[] x_NONE_AABB = FleshDoorBlock.createClosedAndOpenShape(7.0, 0.0, 0.0, 9.0, 16.0, 16.0);
    protected static final VoxelShape[] X_POS_AABB = FleshDoorBlock.createClosedAndOpenShape(14.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] Z_NEG_AABB = FleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 16.0, 16.0, 2.0);
    protected static final VoxelShape[] Z_NONE_AABB = FleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 7.0, 16.0, 16.0, 9.0);
    protected static final VoxelShape[] Z_POS_AABB = FleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 14.0, 16.0, 16.0, 16.0);

    public FleshDoorBlock(BlockBehaviour.Properties properties) {
        super(properties, ModBlockSetTypes.FLESH_SET_TYPE.get());
        this.m_49959_((BlockState)this.m_49966_().m_61124_(ORIENTATION, (Comparable)((Object)Orientation.X_MIDDLE)));
    }

    private static VoxelShape[] createClosedAndOpenShape(double x0, double y0, double z0, double x1, double y1, double z1) {
        VoxelShape closedShape = Block.m_49796_((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1);
        boolean caseX = x0 == 0.0 && x1 == 16.0;
        boolean caseZ = z0 == 0.0 && z1 == 16.0;
        double offset = 2.0;
        double xA = caseX ? x0 + offset : x0;
        double zA = caseZ ? z0 + offset : z0;
        double xB = caseX ? x1 - offset : x1;
        double zB = caseZ ? z1 - offset : z1;
        VoxelShape openShapeBottom = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xA, (double)(y0 + offset), (double)zA, (double)xB, (double)y1, (double)zB), (BooleanOp)BooleanOp.f_82687_);
        VoxelShape openShapeTop = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xA, (double)y0, (double)zA, (double)xB, (double)(y1 - offset), (double)zB), (BooleanOp)BooleanOp.f_82687_);
        VoxelShape openShapeForCollision = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xA, (double)y0, (double)zA, (double)xB, (double)y1, (double)zB), (BooleanOp)BooleanOp.f_82687_);
        return new VoxelShape[]{closedShape, openShapeBottom, openShapeTop, openShapeForCollision};
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ORIENTATION});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() >= level.m_151558_() - 1 || !level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            return null;
        }
        BlockState state = this.m_49966_();
        if (!context.m_7058_()) {
            Orientation orientation = Orientation.getXZOrientationFrom(context);
            state = (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation));
        } else {
            boolean isXAxis = context.m_8125_().m_122434_() == Direction.Axis.X;
            state = (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)(isXAxis ? Orientation.X_MIDDLE : Orientation.Z_MIDDLE)));
        }
        if (level.m_276867_(pos) || level.m_276867_(pos.m_7494_())) {
            state = (BlockState)((BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.LOWER);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState newState = (BlockState)state.m_61122_((Property)f_52727_);
        level.m_7731_(pos, newState, 10);
        this.triggerOpenCloseEvent((Entity)player, level, pos, this.m_52815_(newState));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_153165_(@Nullable Entity user, Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)f_52727_) != open) {
            BlockState newState = (BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open));
            level.m_7731_(pos, newState, 10);
            this.triggerOpenCloseEvent(user, level, pos, open);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.isLowerHalf(state) || level.m_8055_(pos.m_7495_()).m_60713_((Block)this);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean hasSignal;
        boolean bl = level.m_276867_(pos) || level.m_276867_(pos.m_121945_(this.isLowerHalf(state) ? Direction.UP : Direction.DOWN)) ? true : (hasSignal = false);
        if (!this.m_49966_().m_60713_(block) && hasSignal != this.isPowered(state)) {
            if (this.m_52815_(state) != hasSignal) {
                state = (BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(hasSignal));
                this.triggerOpenCloseEvent(null, level, pos, hasSignal);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasSignal)), 2);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)f_52730_);
        if (direction.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            if (neighborState.m_60713_((Block)this) && neighborState.m_61143_((Property)f_52730_) != half) {
                return (BlockState)((BlockState)((BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)((Orientation)((Object)neighborState.m_61143_(ORIENTATION)))))).m_61124_((Property)f_52727_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_52727_)))).m_61124_((Property)f_52729_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_52729_)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        if (half == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected void triggerOpenCloseEvent(@Nullable Entity entity, Level level, BlockPos pos, boolean isDoorOpening) {
        Player player;
        this.playSound(entity instanceof Player ? (player = (Player)entity) : null, level, pos, isDoorOpening ? (SoundEvent)ModSoundEvents.FLESH_DOOR_OPEN.get() : (SoundEvent)ModSoundEvents.FLESH_DOOR_CLOSE.get());
        level.m_142346_(entity, isDoorOpening ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    private void playSound(@Nullable Player player, Level level, BlockPos pos, SoundEvent sound) {
        level.m_5594_(player, pos, sound, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public boolean isLowerHalf(BlockState state) {
        return state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER;
    }

    public boolean isPowered(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_52729_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int offset = this.isLowerHalf(state) ? 0 : 1;
        int idx = this.m_52815_(state) ? 1 + offset : 0;
        return switch ((Orientation)((Object)state.m_61143_(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> x_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> x_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            default -> Shapes.m_83144_();
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.m_52815_(state)) {
            return Shapes.m_83040_();
        }
        int i = 0;
        return switch ((Orientation)((Object)state.m_61143_(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[i];
            case Orientation.X_MIDDLE -> x_NONE_AABB[i];
            case Orientation.X_NEGATIVE -> x_NEG_AABB[i];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[i];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[i];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[i];
            default -> Shapes.m_83144_();
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> this.m_52815_(state);
            case PathComputationType.WATER -> false;
        };
    }

    public BlockState m_6843_(BlockState state, Rotation rotationDirection) {
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.rotate(rotationDirection)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.mirror(mirror)));
    }
}

