/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.biolab;

import com.github.elenterius.biomancy.block.base.HorizontalFacingMachineBlock;
import com.github.elenterius.biomancy.block.base.MachineBlockEntity;
import com.github.elenterius.biomancy.block.biolab.BioLabBlockEntity;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import com.github.elenterius.biomancy.util.VoxelShapeUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BioLabBlock
extends HorizontalFacingMachineBlock {
    public static final VoxelShape SHAPE_NORTH = BioLabBlock.createShape(Direction.NORTH);
    public static final VoxelShape SHAPE_SOUTH = BioLabBlock.createShape(Direction.SOUTH);
    public static final VoxelShape SHAPE_WEST = BioLabBlock.createShape(Direction.WEST);
    public static final VoxelShape SHAPE_EAST = BioLabBlock.createShape(Direction.EAST);

    public BioLabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static VoxelShape createShape(Direction direction) {
        return Stream.of(VoxelShapeUtil.createYRotatedTowards(direction, 2.0, 0.0, 2.0, 14.0, 7.0, 14.0), VoxelShapeUtil.createYRotatedTowards(direction, 4.0, 10.0, 4.0, 12.0, 16.0, 12.0), VoxelShapeUtil.createYRotatedTowards(direction, 6.0, 1.0, 12.0, 10.0, 10.0, 15.0), VoxelShapeUtil.createYRotatedTowards(direction, 1.0, 1.0, 4.0, 15.0, 10.0, 12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83144_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.BIO_LAB.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BioLabBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.BIO_LAB.get()), MachineBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BioLabBlockEntity bioLab;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BioLabBlockEntity && (bioLab = (BioLabBlockEntity)blockEntity).canPlayerInteract(player)) {
            if (!level.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)bioLab, buffer -> buffer.m_130064_(pos));
                SoundUtil.broadcastBlockSound((ServerLevel)level, pos, ModSoundEvents.UI_BIO_LAB_OPEN);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> Shapes.m_83144_();
        };
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(5) == 0 && Boolean.TRUE.equals(state.m_61143_((Property)CRAFTING))) {
            int particleAmount = random.m_216339_(1, 5);
            int color = 10145074;
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            for (int i = 0; i < particleAmount; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + (double)((random.m_188501_() - random.m_188501_()) * 0.25f), (double)pos.m_123342_() + 0.65, (double)pos.m_123343_() + 0.5 + (double)((random.m_188501_() - random.m_188501_()) * 0.25f), r, g, b);
            }
            if (random.m_188503_(3) == 0) {
                SoundUtil.clientPlayBlockSound(level, pos, ModSoundEvents.BIO_LAB_CRAFTING_RANDOM, 0.65f);
            }
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        int fuelAmount = BioLabBlock.getFuelAmount(stack);
        if (fuelAmount > 0) {
            tooltip.add(ComponentUtil.emptyLine());
            DecimalFormat df = ClientTextUtil.getDecimalFormatter("#,###,###");
            tooltip.add((Component)ComponentUtil.translatable("tooltip.biomancy.nutrients_fuel").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)ComponentUtil.literal("%s/%s u".formatted(df.format(fuelAmount), df.format(1000L))).m_130948_(TextStyles.NUTRIENTS));
        }
    }

    public static int getFuelAmount(ItemStack stack) {
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        return tag != null && tag.m_128441_("Fuel") ? tag.m_128469_("Fuel").m_128451_("Amount") : 0;
    }
}

