/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.mawhopper;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.block.mawhopper.MawHopperBlock;
import com.github.elenterius.biomancy.block.property.DirectedConnection;
import com.github.elenterius.biomancy.block.property.VertexType;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.inventory.ItemHandlerWrapper;
import com.github.elenterius.biomancy.inventory.SingleItemStackHandler;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MawHopperBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    public static final String INVENTORY_TAG = "Inventory";
    public static final int ITEM_TRANSFER_AMOUNT = 16;
    public static final int DURATION = 11;
    public static final int DELAY = 9;
    public static final Predicate<Entity> CONTAINER_ENTITY_SELECTOR = entity -> entity.m_6084_() && (EntitySelector.f_20405_.test(entity) || entity instanceof Player) && entity.getCapability(ModCapabilities.ITEM_HANDLER, null).isPresent();
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("maw_hopper.idle");
    protected static final RawAnimation PUMPING_ANIM = RawAnimation.begin().thenLoop("maw_hopper.pumping");
    private final SingleItemStackHandler inventory;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int ticks = BiomancyMod.GLOBAL_RANDOM.nextInt(11);
    private LazyOptional<IItemHandler> optionalItemHandler;

    public MawHopperBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.MAW_HOPPER.get(), pos, blockState);
        this.inventory = new SingleItemStackHandler(){

            @Override
            protected void onContentsChanged() {
                MawHopperBlockEntity.this.m_6596_();
            }
        };
        this.optionalItemHandler = LazyOptional.of(() -> this.inventory);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, MawHopperBlockEntity entity) {
        entity.serverTick((ServerLevel)level, pos, state);
    }

    private static LazyOptional<IItemHandler> getItemHandler(ServerLevel level, BlockPos pos, @Nullable Direction direction) {
        LazyOptional capability;
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state.m_155947_() && (blockEntity = level.m_7702_(pos)) != null && (capability = blockEntity.getCapability(ModCapabilities.ITEM_HANDLER, direction)).isPresent()) {
            return capability;
        }
        List list = level.m_6249_((Entity)null, new AABB(pos), CONTAINER_ENTITY_SELECTOR);
        if (!list.isEmpty()) {
            int index = level.f_46441_.m_188503_(list.size());
            return ((Entity)list.get(index)).getCapability(ModCapabilities.ITEM_HANDLER, direction);
        }
        return LazyOptional.empty();
    }

    public static void entityInside(Level level, BlockPos pos, BlockState state, MawHopperBlockEntity blockEntity, Entity entity) {
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            AABB aabb = new AABB(pos.m_121945_(MawHopperBlock.getConnection((BlockState)state).ingoing));
            if (aabb.m_82381_(entity.m_20191_())) {
                MawHopperBlockEntity.addItem(blockEntity.inventory, itemEntity);
            }
        }
    }

    private static boolean addItem(SingleItemStackHandler handler, ItemEntity itemEntity) {
        ItemStack copy = itemEntity.m_32055_().m_41777_();
        int oldCount = copy.m_41613_();
        ItemStack remainder = handler.insertItem(copy, false);
        if (remainder.m_41619_()) {
            itemEntity.m_146870_();
            return true;
        }
        if (remainder.m_41613_() != oldCount) {
            itemEntity.m_32045_(remainder);
            return true;
        }
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ModCapabilities.ITEM_HANDLER) {
            return this.optionalItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optionalItemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.optionalItemHandler = LazyOptional.of(() -> this.inventory);
    }

    private void serverTick(ServerLevel level, BlockPos pos, BlockState state) {
        LazyOptional<IItemHandler> itemHandler;
        BlockPos pullPos;
        ++this.ticks;
        if (this.ticks % 11 == 0 && !this.inventory.isEmpty()) {
            DirectedConnection connection = MawHopperBlock.getConnection(state);
            BlockPos insertPos = pos.m_121945_(connection.outgoing);
            if (level.m_46749_(insertPos)) {
                LazyOptional<IItemHandler> itemHandler2 = MawHopperBlockEntity.getItemHandler(level, insertPos, connection.outgoing.m_122424_());
                itemHandler2.map(this::tryToInsertItems);
            }
        }
        if (this.ticks % 20 == 0 && !this.inventory.isFull() && this.isMawHead() && level.m_46749_(pullPos = pos.m_121945_(MawHopperBlock.getConnection((BlockState)state).ingoing)) && !(itemHandler = MawHopperBlockEntity.getItemHandler(level, pullPos, Direction.DOWN)).map(this::tryToExtractItems).orElse(false).booleanValue()) {
            this.pullItemEntities(level, pullPos);
        }
    }

    private boolean isMawHead() {
        return MawHopperBlock.getVertexType(this.m_58900_()) == VertexType.SOURCE;
    }

    private boolean tryToInsertItems(IItemHandler itemHandler) {
        boolean success;
        ItemStack stack = this.inventory.extractItem(16, false);
        if (stack.m_41619_()) {
            return false;
        }
        int oldCount = stack.m_41613_();
        ItemHandlerWrapper handler = new ItemHandlerWrapper(itemHandler);
        ItemStack remainder = handler.insertItem(stack, false);
        boolean bl = success = remainder.m_41613_() != oldCount;
        if (!remainder.m_41619_()) {
            this.inventory.insertItem(remainder, false);
        }
        return success;
    }

    private boolean tryToExtractItems(IItemHandler itemHandler) {
        if (this.inventory.isFull()) {
            return false;
        }
        ItemHandlerWrapper handler = new ItemHandlerWrapper(itemHandler);
        Predicate<ItemStack> canAcceptItem = stack -> this.inventory.insertItem((ItemStack)stack, true).m_41619_();
        int amount = Math.min(16, this.inventory.getMaxAmount() - this.inventory.getAmount());
        ItemStack extractedStack = handler.extractItemFirstMatch(canAcceptItem, amount, false);
        if (!extractedStack.m_41619_()) {
            this.inventory.insertItem(extractedStack, false);
            return true;
        }
        return false;
    }

    private void pullItemEntities(ServerLevel level, BlockPos pos) {
        List entities = level.m_6443_(ItemEntity.class, new AABB(pos), EntitySelector.f_20402_);
        for (ItemEntity itemEntity : entities) {
            if (!MawHopperBlockEntity.addItem(this.inventory, itemEntity)) continue;
            return;
        }
    }

    public void dropInventoryContents(Level level, BlockPos pos) {
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.inventory.extractItem(this.inventory.getMaxAmount(), false));
    }

    public void giveInventoryContentsTo(Level level, BlockPos pos, Player player) {
        ItemStack stack = this.inventory.extractItem(this.inventory.getMaxAmount(), false);
        if (!stack.m_41619_() && !player.m_36356_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_(INVENTORY_TAG));
    }

    private <E extends MawHopperBlockEntity> PlayState handleAnim(AnimationState<E> event) {
        event.getController().setAnimation(PUMPING_ANIM);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 0, this::handleAnim)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

