/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.property;

import com.mojang.math.Axis;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public enum DirectedConnection implements StringRepresentable
{
    NORTH_SOUTH(Direction.NORTH, Direction.SOUTH),
    NORTH_EAST(Direction.NORTH, Direction.EAST),
    NORTH_WEST(Direction.NORTH, Direction.WEST),
    NORTH_UP(Direction.NORTH, Direction.UP),
    NORTH_DOWN(Direction.NORTH, Direction.DOWN),
    SOUTH_NORTH(Direction.SOUTH, Direction.NORTH),
    SOUTH_EAST(Direction.SOUTH, Direction.EAST),
    SOUTH_WEST(Direction.SOUTH, Direction.WEST),
    SOUTH_UP(Direction.SOUTH, Direction.UP),
    SOUTH_DOWN(Direction.SOUTH, Direction.DOWN),
    EAST_NORTH(Direction.EAST, Direction.NORTH),
    EAST_SOUTH(Direction.EAST, Direction.SOUTH),
    EAST_WEST(Direction.EAST, Direction.WEST),
    EAST_UP(Direction.EAST, Direction.UP),
    EAST_DOWN(Direction.EAST, Direction.DOWN),
    WEST_NORTH(Direction.WEST, Direction.NORTH),
    WEST_SOUTH(Direction.WEST, Direction.SOUTH),
    WEST_EAST(Direction.WEST, Direction.EAST),
    WEST_UP(Direction.WEST, Direction.UP),
    WEST_DOWN(Direction.WEST, Direction.DOWN),
    UP_NORTH(Direction.UP, Direction.NORTH),
    UP_SOUTH(Direction.UP, Direction.SOUTH),
    UP_EAST(Direction.UP, Direction.EAST),
    UP_WEST(Direction.UP, Direction.WEST),
    UP_DOWN(Direction.UP, Direction.DOWN),
    DOWN_NORTH(Direction.DOWN, Direction.NORTH),
    DOWN_SOUTH(Direction.DOWN, Direction.SOUTH),
    DOWN_EAST(Direction.DOWN, Direction.EAST),
    DOWN_WEST(Direction.DOWN, Direction.WEST),
    DOWN_UP(Direction.DOWN, Direction.UP);

    public final Direction ingoing;
    public final Direction outgoing;
    private final boolean isStraight;
    private Quaternionf quaternion;

    private DirectedConnection(Direction in, Direction out) {
        this.ingoing = in;
        this.outgoing = out;
        this.isStraight = in.m_122434_() == out.m_122434_();
    }

    private static Quaternionf computeRotation(DirectedConnection connection) {
        return switch (connection) {
            default -> throw new IncompatibleClassChangeError();
            case NORTH_DOWN, NORTH_SOUTH -> Axis.f_252529_.m_252977_(-90.0f);
            case NORTH_EAST -> {
                Quaternionf quaternion = Axis.f_252529_.m_252977_(-90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(-90.0f));
                yield quaternion;
            }
            case NORTH_WEST -> {
                Quaternionf quaternion = Axis.f_252529_.m_252977_(-90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(90.0f));
                yield quaternion;
            }
            case NORTH_UP -> {
                Quaternionf quaternion = Axis.f_252529_.m_252977_(-90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(-180.0f));
                yield quaternion;
            }
            case SOUTH_UP, SOUTH_NORTH -> Axis.f_252529_.m_252977_(90.0f);
            case SOUTH_EAST -> {
                Quaternionf quaternion = Axis.f_252529_.m_252977_(90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(-90.0f));
                yield quaternion;
            }
            case SOUTH_WEST -> {
                Quaternionf quaternion = Axis.f_252529_.m_252977_(90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(90.0f));
                yield quaternion;
            }
            case SOUTH_DOWN -> {
                Quaternionf quaternion = Axis.f_252529_.m_252977_(90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(-180.0f));
                yield quaternion;
            }
            case EAST_WEST, EAST_NORTH -> Axis.f_252403_.m_252977_(-90.0f);
            case EAST_SOUTH -> {
                Quaternionf quaternion = Axis.f_252403_.m_252977_(90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252529_.m_252977_(-180.0f));
                yield quaternion;
            }
            case EAST_UP -> {
                Quaternionf quaternion = Axis.f_252403_.m_252977_(-90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(90.0f));
                yield quaternion;
            }
            case EAST_DOWN -> {
                Quaternionf quaternion = Axis.f_252403_.m_252977_(-90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(-90.0f));
                yield quaternion;
            }
            case WEST_NORTH, WEST_EAST -> Axis.f_252403_.m_252977_(90.0f);
            case WEST_SOUTH -> {
                Quaternionf quaternion = Axis.f_252403_.m_252977_(-90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252529_.m_252977_(-180.0f));
                yield quaternion;
            }
            case WEST_UP -> {
                Quaternionf quaternion = Axis.f_252403_.m_252977_(90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(-90.0f));
                yield quaternion;
            }
            case WEST_DOWN -> {
                Quaternionf quaternion = Axis.f_252403_.m_252977_(90.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(90.0f));
                yield quaternion;
            }
            case UP_NORTH, UP_DOWN -> new Quaternionf();
            case UP_SOUTH -> Axis.f_252436_.m_252977_(-180.0f);
            case UP_EAST -> Axis.f_252436_.m_252977_(-90.0f);
            case UP_WEST -> Axis.f_252436_.m_252977_(90.0f);
            case DOWN_NORTH, DOWN_UP -> Axis.f_252403_.m_252977_(-180.0f);
            case DOWN_SOUTH -> Axis.f_252529_.m_252977_(-180.0f);
            case DOWN_EAST -> {
                Quaternionf quaternion = Axis.f_252403_.m_252977_(-180.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(90.0f));
                yield quaternion;
            }
            case DOWN_WEST -> {
                Quaternionf quaternion = Axis.f_252403_.m_252977_(-180.0f);
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(-90.0f));
                yield quaternion;
            }
        };
    }

    public static DirectedConnection from(Direction ingoing, Direction outgoing) {
        for (DirectedConnection connection : DirectedConnection.values()) {
            if (connection.ingoing != ingoing || connection.outgoing != outgoing) continue;
            return connection;
        }
        return UP_DOWN;
    }

    public boolean isStraight() {
        return this.isStraight;
    }

    public boolean isCorner() {
        return !this.isStraight;
    }

    public Quaternionf getUnsafeQuaternion() {
        return this.quaternion;
    }

    public Quaternionf getQuaternion() {
        return new Quaternionf((Quaternionfc)this.quaternion);
    }

    public DirectedConnection rotate(Rotation rotation) {
        return DirectedConnection.from(rotation.m_55954_(this.ingoing), this.outgoing);
    }

    private DirectedConnection inverse() {
        for (DirectedConnection connection : DirectedConnection.values()) {
            if (connection.ingoing != this.outgoing || connection.outgoing != this.ingoing) continue;
            return connection;
        }
        return UP_DOWN;
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        for (DirectedConnection directedConnection : DirectedConnection.values()) {
            directedConnection.quaternion = DirectedConnection.computeRotation(directedConnection);
        }
    }
}

