/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.tongue;

import com.github.elenterius.biomancy.block.tongue.TongueBlockEntity;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.util.VoxelShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TongueBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final VoxelShape SHAPE_NORTH = TongueBlock.createVoxelShape(Direction.NORTH);
    public static final VoxelShape SHAPE_SOUTH = TongueBlock.createVoxelShape(Direction.SOUTH);
    public static final VoxelShape SHAPE_WEST = TongueBlock.createVoxelShape(Direction.WEST);
    public static final VoxelShape SHAPE_EAST = TongueBlock.createVoxelShape(Direction.EAST);

    public TongueBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static VoxelShape createVoxelShape(Direction direction) {
        return VoxelShapeUtil.createYRotatedTowards(direction, 2.0, 3.0, 12.0, 14.0, 13.0, 16.0);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityType<E> targetType, BlockEntityTicker<? super E> entityTicker) {
        return targetType == blockEntityType ? entityTicker : null;
    }

    public static Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)f_54117_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickedFace = context.m_43719_();
        if (clickedFace.m_122434_().m_122479_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)clickedFace);
        }
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.TONGUE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : TongueBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlockEntities.TONGUE.get(), TongueBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TongueBlockEntity) {
            TongueBlockEntity blockEntity2 = (TongueBlockEntity)blockEntity;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            blockEntity2.giveInventoryContentsTo(level, pos, player);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TongueBlockEntity) {
                TongueBlockEntity tongue = (TongueBlockEntity)blockEntity;
                tongue.dropInventoryContents(level, pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> Shapes.m_83144_();
        };
    }
}

