/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.client.gui;

import com.github.elenterius.biomancy.client.gui.InjectorScreen;
import com.github.elenterius.biomancy.client.util.GuiRenderUtil;
import com.github.elenterius.biomancy.entity.projectile.BaseProjectile;
import com.github.elenterius.biomancy.init.ModProjectiles;
import com.github.elenterius.biomancy.item.weapon.gun.DevArmCannonItem;
import com.github.elenterius.biomancy.network.ModNetworkHandler;
import com.github.elenterius.biomancy.styles.ColorStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import software.bernie.geckolib.core.object.Color;

public class DevCannonScreen
extends Screen {
    static final float DIAGONAL_OF_ITEM = Mth.f_13994_ * 32.0f;
    static final int DURATION = 10;
    private int ticks;
    private final InteractionHand itemHoldingHand;

    public DevCannonScreen(InteractionHand hand) {
        super((Component)ComponentUtil.translatable("biomancy.dev.wheel_menu"));
        this.itemHoldingHand = hand;
    }

    protected void m_7856_() {
        this.ticks = 0;
        double x = (double)this.f_96541_.m_91268_().m_85443_() / 2.0;
        double y = (double)this.f_96541_.m_91268_().m_85444_() / 2.0 - 16.0;
        InputConstants.m_84833_((long)this.f_96541_.m_91268_().m_85439_(), (int)212993, (double)x, (double)y);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public void m_86600_() {
        if (this.ticks < 0 || this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            this.m_7379_();
            return;
        }
        ItemStack stack = this.f_96541_.f_91074_.m_21120_(this.itemHoldingHand);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof DevArmCannonItem)) {
            this.m_7379_();
            return;
        }
        ++this.ticks;
        if (this.ticks > 10) {
            this.ticks = 10;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (ModProjectiles.PRECONFIGURED_PROJECTILES.isEmpty()) {
            this.m_7379_();
            return false;
        }
        if (this.ticks < 9) {
            return false;
        }
        int segments = ModProjectiles.PRECONFIGURED_PROJECTILES.size() + 1;
        float angleIncrement = (float)Math.PI * 2 / (float)segments;
        float x = (float)this.f_96543_ / 2.0f;
        float y = (float)this.f_96544_ / 2.0f;
        float upperBound = (float)segments * angleIncrement - 1.5707964f + angleIncrement / 2.0f;
        float lowerBound = -1.5707964f - angleIncrement / 2.0f;
        float mouseAngle = (float)Mth.m_14136_((double)(mouseY - (double)y), (double)(mouseX - (double)x));
        if (mouseAngle > upperBound) {
            mouseAngle -= (float)Math.PI * 2;
        }
        if (mouseAngle < lowerBound) {
            mouseAngle += (float)Math.PI * 2;
        }
        for (int idx = 0; idx < segments; ++idx) {
            boolean isMouseInSection;
            float currentAngle = (float)idx * angleIncrement - 1.5707964f;
            boolean bl = isMouseInSection = mouseAngle >= currentAngle - angleIncrement / 2.0f && mouseAngle < currentAngle + angleIncrement / 2.0f;
            if (!isMouseInSection) continue;
            if (idx <= 0) break;
            ModNetworkHandler.sendKeyBindPressToServer(this.itemHoldingHand, (byte)(idx - 1));
            break;
        }
        this.m_7379_();
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.ticks < 0) {
            return;
        }
        float time = (float)this.ticks + partialTick;
        if (time > 10.0f) {
            time = 10.0f;
        }
        this.renderWheel(guiGraphics, mouseX, mouseY, time / 10.0f);
    }

    private void renderWheel(GuiGraphics guiGraphics, int mouseX, int mouseY, float pct) {
        if (ModProjectiles.PRECONFIGURED_PROJECTILES.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        int segments = ModProjectiles.PRECONFIGURED_PROJECTILES.size() + 1;
        float angleIncrement = (float)Math.PI * 2 / (float)segments;
        float baseRadius = DIAGONAL_OF_ITEM / angleIncrement;
        float x = (float)this.f_96543_ / 2.0f;
        float y = (float)this.f_96544_ / 2.0f;
        int radius = Mth.m_14143_((float)(baseRadius * pct));
        int blitOffset = 0;
        float upperBound = (float)segments * angleIncrement - 1.5707964f + angleIncrement / 2.0f;
        float lowerBound = -1.5707964f - angleIncrement / 2.0f;
        float mouseAngle = (float)Mth.m_14136_((double)((float)mouseY - y), (double)((float)mouseX - x));
        if (mouseAngle > upperBound) {
            mouseAngle -= (float)Math.PI * 2;
        }
        if (mouseAngle < lowerBound) {
            mouseAngle += (float)Math.PI * 2;
        }
        ModProjectiles.ConfiguredProjectile<? extends BaseProjectile> configuredProjectile = null;
        float textAngle = 0.0f;
        for (int idx = 0; idx < segments; ++idx) {
            float currentAngle = (float)idx * angleIncrement - 1.5707964f;
            boolean isMouseInSection = (float)radius > baseRadius - 1.0f && mouseAngle >= currentAngle - angleIncrement / 2.0f && mouseAngle < currentAngle + angleIncrement / 2.0f;
            int color = isMouseInSection ? ColorStyles.GENERIC_TOOLTIP.borderStartColor() & 0xFAFFFFFF : ColorStyles.GENERIC_TOOLTIP.backgroundColor() & 0xE0FFFFFF;
            this.drawSegment(guiGraphics, x, y, radius, currentAngle - angleIncrement / 2.0f, currentAngle, color, blitOffset);
            this.drawSegment(guiGraphics, x, y, radius, currentAngle, currentAngle + angleIncrement / 2.0f, color, blitOffset);
            float v = x + (float)radius * Mth.m_14089_((float)currentAngle);
            float w = y + (float)radius * Mth.m_14031_((float)currentAngle);
            if (idx == 0) {
                guiGraphics.m_280163_(InjectorScreen.ICONS, Mth.m_14143_((float)(v - 8.0f)), Mth.m_14143_((float)(w - 8.0f)), 16.0f, 0.0f, 16, 16, 32, 16);
            } else {
                int argb = Color.HSBtoARGB((float)((float)idx / (float)segments), (float)0.75f, (float)0.5f);
                GuiRenderUtil.fill(guiGraphics, v - 8.0f, w - 8.0f, v + 8.0f, w + 8.0f, blitOffset, argb);
            }
            if (!isMouseInSection) continue;
            if (idx > 0) {
                configuredProjectile = ModProjectiles.PRECONFIGURED_PROJECTILES.get(idx - 1);
            }
            textAngle = currentAngle;
        }
        if ((float)radius <= baseRadius - 1.0f) {
            return;
        }
        MutableComponent text = configuredProjectile == null ? ComponentUtil.literal("Cancel") : ComponentUtil.literal(configuredProjectile.name());
        int textRadius = radius + 16 + 8 + 2;
        float xt = x + (float)textRadius * Mth.m_14089_((float)textAngle);
        float yt = y + (float)textRadius * Mth.m_14031_((float)textAngle);
        int lineWidth = this.f_96547_.m_92852_((FormattedText)text);
        float offsetAngle = textAngle + 1.5707964f;
        if (offsetAngle == 0.0f || offsetAngle == (float)Math.PI) {
            xt -= (float)lineWidth / 2.0f;
        }
        if (offsetAngle > (float)Math.PI) {
            xt -= (float)lineWidth;
        }
        guiGraphics.m_280168_().m_85836_();
        float minX = xt - 3.0f;
        Objects.requireNonNull(this.f_96547_);
        float minY = yt - 9.0f / 2.0f - 3.0f;
        float maxX = xt + (float)lineWidth + 2.0f;
        Objects.requireNonNull(this.f_96547_);
        float maxY = yt + 9.0f / 2.0f + 2.0f;
        GuiRenderUtil.fill(guiGraphics, minX, minY, maxX, maxY, blitOffset, ColorStyles.GENERIC_TOOLTIP.backgroundColor() & 0xE0FFFFFF);
        int n = (int)xt;
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280614_(this.f_96547_, (Component)text, n, (int)(yt - 9.0f / 2.0f), -1, true);
        guiGraphics.m_280168_().m_85849_();
    }

    public void drawSegment(GuiGraphics guiGraphics, float x, float y, float radius, float startAngle, float endAngle, int argbColor, int z) {
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        float innerRadius = Math.max(radius - 16.0f, 0.0f);
        bufferBuilder.m_252986_(matrix4f, x + innerRadius * Mth.m_14089_((float)startAngle), y + innerRadius * Mth.m_14031_((float)startAngle), (float)z).m_193479_(argbColor).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x + innerRadius * Mth.m_14089_((float)endAngle), y + innerRadius * Mth.m_14031_((float)endAngle), (float)z).m_193479_(argbColor).m_5752_();
        float outerRadius = radius + 16.0f;
        bufferBuilder.m_252986_(matrix4f, x + outerRadius * Mth.m_14089_((float)endAngle), y + outerRadius * Mth.m_14031_((float)endAngle), (float)z).m_193479_(argbColor).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x + outerRadius * Mth.m_14089_((float)startAngle), y + outerRadius * Mth.m_14031_((float)startAngle), (float)z).m_193479_(argbColor).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }
}

