/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AnyFoodIngredient
extends AbstractIngredient {
    private static final Predicate<FoodProperties> NUTRITION_PREDICATE = foodProperties -> foodProperties != null && foodProperties.m_38744_() > 0;
    @Nullable
    private ItemStack[] stacks = null;

    public boolean m_43947_() {
        return false;
    }

    public ItemStack[] m_43908_() {
        this.resolve();
        return this.stacks;
    }

    private void resolve() {
        if (this.stacks == null) {
            this.stacks = (ItemStack[])ForgeRegistries.ITEMS.getValues().stream().filter(Item::m_41472_).map(ItemStack::new).filter(stack -> NUTRITION_PREDICATE.test(stack.getFoodProperties(null))).toArray(ItemStack[]::new);
        }
    }

    protected void invalidate() {
        this.stacks = null;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        if (!stack.m_41614_()) {
            return false;
        }
        return NUTRITION_PREDICATE.test(stack.getFoodProperties(null));
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.requireNonNull(CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE)).toString());
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<AnyFoodIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public AnyFoodIngredient parse(FriendlyByteBuf buffer) {
            return new AnyFoodIngredient();
        }

        public AnyFoodIngredient parse(JsonObject json) {
            return new AnyFoodIngredient();
        }

        public void write(FriendlyByteBuf buffer, AnyFoodIngredient ingredient) {
        }
    }
}

