/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob;

import com.github.elenterius.biomancy.init.ModDamageTypes;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModProjectiles;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.util.animation.MobAnimations;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FleshChicken
extends Chicken
implements RangedAttackMob,
GeoEntity {
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    boolean hasAttacked;

    public FleshChicken(EntityType<? extends Chicken> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 40, 20.0f));
        this.f_21346_.m_25352_(1, (Goal)new FleshChickenHurtByTargetGoal(this).m_26044_(new Class[0]));
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source.m_276093_(ModDamageTypes.CORROSIVE_ACID);
    }

    public void m_6504_(LivingEntity target, float velocity) {
        double x = this.m_20185_() - (double)(this.m_20205_() * Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))));
        double y = this.m_20188_() + 0.25;
        double z = this.m_20189_() + (double)(this.m_20205_() * Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))));
        ModProjectiles.GASTRIC_SPIT.shoot(this.m_9236_(), new Vec3(x, y, z), target.m_146892_());
        this.hasAttacked = true;
    }

    @Nullable
    public ItemEntity m_19998_(ItemLike item) {
        if (item == Items.f_42521_) {
            item = (ItemLike)ModItems.BILE.get();
        }
        return super.m_19998_(item);
    }

    @Nullable
    public Chicken m_142606_(ServerLevel level, AgeableMob otherParent) {
        if (otherParent.getClass() != ((Object)((Object)this)).getClass() && this.f_19796_.m_188501_() < 0.15f) {
            return (Chicken)otherParent.m_142606_(level, (AgeableMob)this);
        }
        return (Chicken)((EntityType)ModEntityTypes.FLESH_CHICKEN.get()).m_20615_((Level)level);
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        return otherAnimal instanceof Chicken && this.m_27593_() && otherAnimal.m_27593_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.FLESH_CHICKEN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.FLESH_CHICKEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.FLESH_CHICKEN_DEATH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{MobAnimations.walkController(this)});
        controllers.add(new AnimationController[]{MobAnimations.babyTransformController(this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static class FleshChickenHurtByTargetGoal
    extends HurtByTargetGoal {
        public FleshChickenHurtByTargetGoal(FleshChicken fleshChicken) {
            super((PathfinderMob)fleshChicken, new Class[0]);
        }

        public boolean m_8045_() {
            Mob mob = this.f_26135_;
            if (mob instanceof FleshChicken) {
                FleshChicken chicken = (FleshChicken)mob;
                if (chicken.hasAttacked) {
                    chicken.hasAttacked = false;
                    return false;
                }
            }
            return super.m_8045_();
        }
    }
}

