/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.init.AcidInteractions;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModPredicates;
import com.github.elenterius.biomancy.init.ModRecipeBookTypes;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.init.ModTriggers;
import com.github.elenterius.biomancy.integration.ModsCompatHandler;
import com.github.elenterius.biomancy.item.extractor.ExtractorItem;
import com.github.elenterius.biomancy.item.injector.InjectorItem;
import com.github.elenterius.biomancy.network.ModNetworkHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="biomancy", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonSetupHandler {
    private CommonSetupHandler() {
    }

    @SubscribeEvent
    public static void onSetup(FMLCommonSetupEvent event) {
        ModNetworkHandler.register();
        ModRecipeBookTypes.init();
        event.enqueueWork(() -> {
            ModTriggers.register();
            ModPredicates.registerItemPredicates();
            CommonSetupHandler.registerDispenserBehaviors();
            ModRecipes.registerComposterRecipes();
            AcidInteractions.register();
        });
        ModFluids.registerInteractions();
        ModRecipes.registerBrewingRecipes();
        ModsCompatHandler.onBiomancyCommonSetup(event);
    }

    public static void dumpBiomeTemperatureAndHumidity() {
        BiomancyMod.LOGGER.info("dumping biome default temperatures to biome_temperatures.csv...");
        try {
            Stream<String> stringStream = ForgeRegistries.BIOMES.getEntries().stream().map(keyEntry -> "%s,%s,%s".formatted(((ResourceKey)keyEntry.getKey()).m_135782_(), Float.valueOf(((Biome)keyEntry.getValue()).m_47554_()), Float.valueOf(((Biome)keyEntry.getValue()).getModifiedClimateSettings().f_47683_())));
            Files.write(Paths.get("biome_temperatures.csv", new String[0]), stringStream::iterator, new OpenOption[0]);
        }
        catch (IOException e) {
            BiomancyMod.LOGGER.error("Failed to dump biome temps!", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            ModRecipes.registerIngredientSerializers();
        }
    }

    private static void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.ESSENCE_EXTRACTOR.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                this.m_123573_(ExtractorItem.tryExtractEssence(source.m_7727_(), pos, stack));
                if (this.m_123570_() && stack.m_220157_(1, source.m_7727_().m_213780_(), null)) {
                    stack.m_41764_(0);
                }
                return stack;
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.INJECTOR.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                this.m_123573_(InjectorItem.tryInjectLivingEntity(source.m_7727_(), pos, stack));
                if (this.m_123570_() && stack.m_220157_(1, source.m_7727_().m_213780_(), null)) {
                    stack.m_41764_(0);
                }
                return stack;
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.ACID_BUCKET.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel level = source.m_7727_();
                DispensibleContainerItem containerItem = (DispensibleContainerItem)stack.m_41720_();
                if (containerItem.emptyContents(null, (Level)level, pos, null, stack)) {
                    containerItem.m_142131_(null, (Level)level, stack, pos);
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
        });
    }
}

