/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackInventory {
    private final ItemStack cachedInventoryHost;
    private final InventorySerializer serializer;
    private final ItemStackHandler itemHandler;
    private final LazyOptional<IItemHandler> optionalItemHandler;

    ItemStackInventory(int slots, final int maxSlotSize, ItemStack inventoryHost, InventorySerializer serializer) {
        this.serializer = serializer;
        this.itemHandler = new ItemStackHandler(slots){

            public int getSlotLimit(int slot) {
                return maxSlotSize;
            }

            protected void onContentsChanged(int slot) {
                ItemStackInventory.this.serializeToHost();
            }
        };
        this.optionalItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.cachedInventoryHost = inventoryHost;
    }

    public static ItemStackInventory create(int slots, int maxSlotSize, ItemStack inventoryHost, InventorySerializer inventorySerializer) {
        ItemStackInventory inventory = new ItemStackInventory(slots, maxSlotSize, inventoryHost, inventorySerializer);
        inventory.deserializeFromHost();
        return inventory;
    }

    public static ItemStackInventory create(int slots, int maxSlotSize, ItemStack inventoryHost) {
        ItemStackInventory inventory = new ItemStackInventory(slots, maxSlotSize, inventoryHost, InventorySerializer.DEFAULT);
        inventory.deserializeFromHost();
        return inventory;
    }

    private void serializeToHost() {
        this.serializer.serialize(this.cachedInventoryHost.m_41784_(), (INBTSerializable<CompoundTag>)this.itemHandler);
    }

    private void deserializeFromHost() {
        this.serializer.deserialize(this.cachedInventoryHost.m_41784_(), (INBTSerializable<CompoundTag>)this.itemHandler);
    }

    public boolean stillValid(Player player) {
        return !this.cachedInventoryHost.m_41619_();
    }

    public IItemHandler getItemHandler() {
        this.deserializeFromHost();
        return this.itemHandler;
    }

    public LazyOptional<IItemHandler> getLazyOptional() {
        this.deserializeFromHost();
        return this.optionalItemHandler;
    }

    public static interface InventorySerializer {
        public static final String NBT_KEY = "Inventory";
        public static final InventorySerializer DEFAULT = new InventorySerializer(){};
        public static final InventorySerializer BLOCK_ENTITY_TAG = new InventorySerializer(){
            public static final String BLOCK_ENTITY_KEY = "BlockEntityTag";

            @Override
            public void serialize(CompoundTag store, INBTSerializable<CompoundTag> serializable) {
                CompoundTag blockTag = store.m_128469_(BLOCK_ENTITY_KEY);
                blockTag.m_128365_(InventorySerializer.NBT_KEY, serializable.serializeNBT());
                store.m_128365_(BLOCK_ENTITY_KEY, (Tag)blockTag);
            }

            @Override
            public void deserialize(CompoundTag store, INBTSerializable<CompoundTag> deserializable) {
                CompoundTag blockTag = store.m_128469_(BLOCK_ENTITY_KEY);
                deserializable.deserializeNBT((Tag)blockTag.m_128469_(InventorySerializer.NBT_KEY));
            }

            @Override
            public CompoundTag unwrap(CompoundTag store) {
                CompoundTag blockTag = store.m_128469_(BLOCK_ENTITY_KEY);
                return blockTag.m_128469_(InventorySerializer.NBT_KEY);
            }
        };

        default public void serialize(CompoundTag store, INBTSerializable<CompoundTag> serializable) {
            store.m_128365_(NBT_KEY, serializable.serializeNBT());
        }

        default public void deserialize(CompoundTag store, INBTSerializable<CompoundTag> deserializable) {
            deserializable.deserializeNBT((Tag)store.m_128469_(NBT_KEY));
        }

        default public CompoundTag unwrap(CompoundTag store) {
            return store.m_128469_(NBT_KEY);
        }
    }
}

