/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.block.property.BlockPropertyUtil;
import com.github.elenterius.biomancy.item.SimpleItem;
import com.github.elenterius.biomancy.util.PillarPlantUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;

public class FertilizerItem
extends SimpleItem {
    public FertilizerItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean applyFertilizer(ItemStack stack, Level level, BlockPos pos, Direction clickedFace) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            return FertilizerItem.growBonmealableBlock(level, pos, state, bonemealableBlock);
        }
        if (state.m_60783_((BlockGetter)level, pos, clickedFace) && BoneMealItem.m_40631_((ItemStack)ItemStack.f_41583_, (Level)level, (BlockPos)pos.m_121945_(clickedFace), (Direction)clickedFace)) {
            return true;
        }
        if (block == Blocks.f_50493_) {
            return FertilizerItem.growDirtAreaIntoGrassBlocks(level, pos);
        }
        if (block == Blocks.f_50195_) {
            return FertilizerItem.growDirtAndGrassAreaIntoMycelium(level, pos);
        }
        if (block instanceof ChorusFlowerBlock) {
            return FertilizerItem.growChorusFlower(level, pos, state);
        }
        if (PillarPlantUtil.isPillarPlant(block)) {
            return PillarPlantUtil.applyMegaGrowthBoost(level, pos, state, block);
        }
        if (block instanceof IPlantable) {
            return FertilizerItem.growPlantableBlock(level, pos, state, block);
        }
        return false;
    }

    private static boolean growChorusFlower(Level level, BlockPos pos, BlockState state) {
        boolean isAttachedToChorusPlant;
        if ((Integer)state.m_61143_((Property)ChorusFlowerBlock.f_51647_) >= 5) {
            return false;
        }
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        if (stateBelow.m_60713_(Blocks.f_50259_)) {
            if (!level.m_5776_()) {
                ChorusFlowerBlock.m_220962_((LevelAccessor)level, (BlockPos)pos, (RandomSource)level.f_46441_, (int)8);
            }
            return true;
        }
        boolean bl = isAttachedToChorusPlant = stateBelow.m_60713_(Blocks.f_50490_) || level.m_8055_(pos.m_122012_()).m_60713_(Blocks.f_50490_) || level.m_8055_(pos.m_122019_()).m_60713_(Blocks.f_50490_) || level.m_8055_(pos.m_122024_()).m_60713_(Blocks.f_50490_) || level.m_8055_(pos.m_122029_()).m_60713_(Blocks.f_50490_);
        if (isAttachedToChorusPlant) {
            if (!level.m_5776_()) {
                ChorusFlowerBlock.m_220962_((LevelAccessor)level, (BlockPos)pos, (RandomSource)level.f_46441_, (int)8);
            }
            return true;
        }
        return false;
    }

    private static boolean growDirtAreaIntoGrassBlocks(Level level, BlockPos startPos) {
        if (!level.m_8055_(startPos.m_7494_()).m_60795_()) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_46597_(startPos, Blocks.f_50440_.m_49966_());
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)startPos.m_123341_() + 0.5, (double)startPos.m_123342_() + 1.25, (double)startPos.m_123343_() + 0.5, 5, 0.25, 0.25, 0.25, 0.0);
            BlockPos.m_276833_((BlockPos)startPos, (int)10, (int)20, (pos, queue) -> {
                queue.accept(pos.m_7918_(-1, 1, 0));
                queue.accept(pos.m_7918_(-1, 0, 0));
                queue.accept(pos.m_7918_(-1, -1, 0));
                queue.accept(pos.m_7918_(1, 1, 0));
                queue.accept(pos.m_7918_(1, 0, 0));
                queue.accept(pos.m_7918_(1, -1, 0));
                queue.accept(pos.m_7918_(0, 1, 1));
                queue.accept(pos.m_7918_(0, 0, 1));
                queue.accept(pos.m_7918_(0, -1, 1));
                queue.accept(pos.m_7918_(0, 1, -1));
                queue.accept(pos.m_7918_(0, 0, -1));
                queue.accept(pos.m_7918_(0, -1, -1));
            }, pos -> {
                if (pos.equals((Object)startPos)) {
                    return true;
                }
                BlockState currentState = serverLevel.m_8055_(pos);
                boolean isAirAbove = serverLevel.m_8055_(pos.m_7494_()).m_60795_();
                if (currentState.m_60713_(Blocks.f_50493_) && isAirAbove) {
                    serverLevel.m_46597_(pos, Blocks.f_50440_.m_49966_());
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.25, (double)pos.m_123343_() + 0.5, 5, 0.25, 0.25, 0.25, 0.0);
                    return true;
                }
                return (currentState.m_204336_(BlockTags.f_144274_) || currentState.m_60713_(Blocks.f_50440_)) && isAirAbove;
            });
        }
        return true;
    }

    private static boolean growDirtAndGrassAreaIntoMycelium(Level level, BlockPos startPos) {
        if (!level.m_8055_(startPos.m_7494_()).m_60795_()) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int visited = BlockPos.m_276833_((BlockPos)startPos, (int)10, (int)20, (pos, queue) -> {
                queue.accept(pos.m_7918_(-1, 1, 0));
                queue.accept(pos.m_7918_(-1, 0, 0));
                queue.accept(pos.m_7918_(-1, -1, 0));
                queue.accept(pos.m_7918_(1, 1, 0));
                queue.accept(pos.m_7918_(1, 0, 0));
                queue.accept(pos.m_7918_(1, -1, 0));
                queue.accept(pos.m_7918_(0, 1, 1));
                queue.accept(pos.m_7918_(0, 0, 1));
                queue.accept(pos.m_7918_(0, -1, 1));
                queue.accept(pos.m_7918_(0, 1, -1));
                queue.accept(pos.m_7918_(0, 0, -1));
                queue.accept(pos.m_7918_(0, -1, -1));
            }, pos -> {
                if (pos.equals((Object)startPos)) {
                    return true;
                }
                BlockState currentState = serverLevel.m_8055_(pos);
                boolean isAirAbove = serverLevel.m_8055_(pos.m_7494_()).m_60795_();
                if ((currentState.m_60713_(Blocks.f_50493_) || currentState.m_60713_(Blocks.f_50440_)) && isAirAbove) {
                    serverLevel.m_46597_(pos, Blocks.f_50195_.m_49966_());
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.25, (double)pos.m_123343_() + 0.5, 5, 0.25, 0.25, 0.25, 0.0);
                    return true;
                }
                return (currentState.m_204336_(BlockTags.f_144274_) || currentState.m_60713_(Blocks.f_50195_)) && isAirAbove;
            });
            return visited > 1;
        }
        return true;
    }

    private static boolean growPlantableBlock(Level level, BlockPos pos, BlockState state, Block block) {
        Optional<IntegerProperty> property = BlockPropertyUtil.getAgeProperty(state);
        if (property.isPresent()) {
            int maxAge;
            IntegerProperty ageProperty = property.get();
            int age = (Integer)state.m_61143_((Property)ageProperty);
            if (age < (maxAge = BlockPropertyUtil.getMaxValue(ageProperty))) {
                if (!level.m_5776_()) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(maxAge)), 2);
                    level.m_46796_(2005, pos, 5);
                }
                return true;
            }
        } else if (block.m_6724_(state)) {
            if (!level.m_5776_() && !level.m_183326_().m_183588_(pos, (Object)block)) {
                level.m_186460_(pos, block, 2);
                level.m_46796_(2005, pos, 5);
            }
            return true;
        }
        return false;
    }

    private static boolean growBonmealableBlock(Level level, BlockPos pos, BlockState state, BonemealableBlock block) {
        int maxAge;
        IntegerProperty ageProperty;
        int age;
        Optional<IntegerProperty> property;
        if (!block.m_7370_((LevelReader)level, pos, state, level.f_46443_)) {
            return false;
        }
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState prevState = state;
        if (state.m_204336_(BlockTags.f_13104_) && state.m_61138_((Property)BlockStateProperties.f_61387_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61387_, (Comparable)Integer.valueOf(1));
        }
        if ((property = BlockPropertyUtil.getAgeProperty(state)).isPresent() && (age = ((Integer)state.m_61143_((Property)(ageProperty = property.get()))).intValue()) < (maxAge = BlockPropertyUtil.getMaxValue(ageProperty))) {
            state = (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(maxAge));
        }
        if (state != prevState) {
            serverLevel.m_7731_(pos, state, 2);
        }
        block.m_214148_(serverLevel, serverLevel.f_46441_, pos, state);
        serverLevel.m_46796_(2005, pos, 5);
        return true;
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (FertilizerItem.applyFertilizer(stack, level, clickedPos, context.m_43719_())) {
            if (!level.f_46443_) {
                stack.m_41774_(1);
                level.m_5594_(null, clickedPos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

