/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.init.ModBioForgeTabs;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class BioForgeTab {
    private static final String JSON_KEY = "bio_forge_tab";
    private final int sortPriority;
    private final Item iconItem;

    public BioForgeTab(int sortPriority, Item iconItem) {
        this.sortPriority = sortPriority;
        this.iconItem = iconItem;
    }

    public BioForgeTab(Item itemSupplier) {
        this(0, itemSupplier);
    }

    @Nullable
    public static BioForgeTab fromJson(JsonObject json) {
        String categoryId = GsonHelper.m_13906_((JsonObject)json, (String)JSON_KEY);
        return (BioForgeTab)ModBioForgeTabs.REGISTRY.get().getValue(new ResourceLocation(categoryId));
    }

    public static String getTabId(JsonObject json) {
        return GsonHelper.m_13906_((JsonObject)json, (String)JSON_KEY);
    }

    public static BioForgeTab fromNetwork(FriendlyByteBuf buffer) {
        BioForgeTab value = (BioForgeTab)ModBioForgeTabs.REGISTRY.get().getValue(buffer.m_130281_());
        return value != null ? value : (BioForgeTab)ModBioForgeTabs.MISC.get();
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(ModBioForgeTabs.REGISTRY.get().getKey((Object)this));
    }

    public void toJson(JsonObject json) {
        json.addProperty(JSON_KEY, ModBioForgeTabs.REGISTRY.get().getKey((Object)this).toString());
    }

    public ItemStack getIcon() {
        return new ItemStack((ItemLike)this.iconItem);
    }

    public String enumId() {
        return BioForgeTab.enumIdFrom(ModBioForgeTabs.REGISTRY.get().getKey((Object)this));
    }

    public static String enumIdFrom(ResourceLocation key) {
        return "bio_forge_tab_" + key.m_135827_() + "_" + key.m_135815_();
    }

    public String translationKey() {
        return ModBioForgeTabs.REGISTRY.get().getKey((Object)this).m_214296_(JSON_KEY);
    }

    public int sortPriority() {
        return this.sortPriority;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BioForgeTab that = (BioForgeTab)obj;
        return ModBioForgeTabs.REGISTRY.get().getKey((Object)this).equals((Object)ModBioForgeTabs.REGISTRY.get().getKey((Object)that)) && this.sortPriority == that.sortPriority && Objects.equals(this.iconItem, that.iconItem);
    }

    public String toString() {
        return "BioForgeTab[id=" + ModBioForgeTabs.REGISTRY.get().getKey((Object)this) + ", sortPriority=" + this.sortPriority + ", iconSupplier=" + this.iconItem + "]";
    }
}

