/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.block.digester.DigesterBlockEntity;
import com.github.elenterius.biomancy.crafting.recipe.SimpleRecipeType;
import com.github.elenterius.biomancy.init.ModMenuTypes;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.menu.ISlotZone;
import com.github.elenterius.biomancy.menu.PlayerContainerMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class DigesterMenu
extends PlayerContainerMenu {
    protected final Level level;
    private final DigesterBlockEntity digester;

    protected DigesterMenu(int id, Inventory playerInventory, @Nullable DigesterBlockEntity digester) {
        super((MenuType)ModMenuTypes.DIGESTER.get(), id, playerInventory, 111, 169);
        this.level = playerInventory.f_35978_.m_9236_();
        this.digester = digester;
        if (digester != null) {
            this.m_38897_((Slot)new SlotItemHandler(digester.getFuelInventory(), 0, 39, 68));
            this.m_38897_((Slot)new SlotItemHandler(digester.getInputInventory(), 0, 80, 24));
            InventoryHandler<?> itemHandler = digester.getOutputInventory();
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 0, 69, 68));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 1, 91, 68));
            this.m_38884_(digester.getStateData());
        }
    }

    public static DigesterMenu createServerMenu(int screenId, Inventory playerInventory, DigesterBlockEntity digester) {
        return new DigesterMenu(screenId, playerInventory, digester);
    }

    public static DigesterMenu createClientMenu(int screenId, Inventory playerInventory, FriendlyByteBuf extraData) {
        DigesterBlockEntity be;
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        DigesterBlockEntity digester = blockEntity instanceof DigesterBlockEntity ? (be = (DigesterBlockEntity)blockEntity) : null;
        return new DigesterMenu(screenId, playerInventory, digester);
    }

    public boolean m_6875_(Player player) {
        return this.digester != null && this.digester.canPlayerInteract(player);
    }

    public float getCraftingProgressNormalized() {
        if (this.digester.getStateData().timeForCompletion == 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)this.digester.getStateData().timeElapsed / (float)this.digester.getStateData().timeForCompletion), (float)0.0f, (float)1.0f);
    }

    public float getFuelAmountNormalized() {
        return Mth.m_14036_((float)((float)this.digester.getStateData().fuelHandler.getFuelAmount() / (float)this.digester.getStateData().fuelHandler.getMaxFuelAmount()), (float)0.0f, (float)1.0f);
    }

    public int getFuelAmount() {
        return this.digester.getStateData().fuelHandler.getFuelAmount();
    }

    public int getMaxFuelAmount() {
        return this.digester.getStateData().fuelHandler.getMaxFuelAmount();
    }

    public int getFuelCost() {
        return this.digester.getStateData().getFuelCost();
    }

    public ItemStack m_7648_(Player player, int index) {
        boolean successfulTransfer;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack copyOfStack = stackInSlot.m_41777_();
        SlotZone slotZone = SlotZone.getZoneFromIndex(index);
        switch (slotZone) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OUTPUT_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_HOTBAR, SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, true);
                break;
            }
            case INPUT_ZONE: 
            case FUEL_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_MAIN_INVENTORY, SlotZone.PLAYER_HOTBAR, stackInSlot, false);
                break;
            }
            case PLAYER_HOTBAR: 
            case PLAYER_MAIN_INVENTORY: {
                boolean bl = successfulTransfer = this.mergeIntoInputZone(stackInSlot) || this.mergeIntoFuelZone(stackInSlot) || this.mergeIntoPlayerZone(slotZone, stackInSlot);
            }
        }
        if (!successfulTransfer) {
            return ItemStack.f_41583_;
        }
        if (slotZone == SlotZone.OUTPUT_ZONE) {
            slot.m_40234_(stackInSlot, copyOfStack);
        }
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stackInSlot.m_41613_() == copyOfStack.m_41613_()) {
            BiomancyMod.LOGGER.warn(MarkerManager.getMarker((String)"DecomposerMenu"), "Stack transfer failed in an unexpected way!");
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        return copyOfStack;
    }

    private boolean mergeIntoInputZone(ItemStack stackInSlot) {
        if (((SimpleRecipeType.ItemStackRecipeType)DigesterBlockEntity.RECIPE_TYPE.get()).getRecipeForIngredient(this.level, stackInSlot).isPresent()) {
            return this.mergeInto(SlotZone.INPUT_ZONE, stackInSlot, false);
        }
        return false;
    }

    private boolean mergeIntoFuelZone(ItemStack stackInSlot) {
        if (Nutrients.isValidFuel(stackInSlot)) {
            return this.mergeInto(SlotZone.FUEL_ZONE, stackInSlot, true);
        }
        return false;
    }

    private boolean mergeIntoPlayerZone(SlotZone slotZone, ItemStack stackInSlot) {
        if (slotZone == SlotZone.PLAYER_HOTBAR) {
            return this.mergeInto(SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, false);
        }
        return this.mergeInto(SlotZone.PLAYER_HOTBAR, stackInSlot, false);
    }

    public static enum SlotZone implements ISlotZone
    {
        PLAYER_HOTBAR(0, 9),
        PLAYER_MAIN_INVENTORY(PLAYER_HOTBAR, 27),
        FUEL_ZONE(PLAYER_MAIN_INVENTORY, 1),
        INPUT_ZONE(FUEL_ZONE, 1),
        OUTPUT_ZONE(INPUT_ZONE, 2);

        public final int firstIndex;
        public final int slotCount;
        public final int lastIndexPlus1;

        private SlotZone(SlotZone slotZone, int numberOfSlots) {
            this(slotZone.lastIndexPlus1, numberOfSlots);
        }

        private SlotZone(int firstIndex, int numberOfSlots) {
            this.firstIndex = firstIndex;
            this.slotCount = numberOfSlots;
            this.lastIndexPlus1 = firstIndex + numberOfSlots;
        }

        public static SlotZone getZoneFromIndex(int slotIndex) {
            for (SlotZone slotZone : SlotZone.values()) {
                if (slotIndex < slotZone.firstIndex || slotIndex >= slotZone.lastIndexPlus1) continue;
                return slotZone;
            }
            throw new IndexOutOfBoundsException("Unexpected slotIndex");
        }

        @Override
        public int getFirstIndex() {
            return this.firstIndex;
        }

        @Override
        public int getLastIndexPlusOne() {
            return this.lastIndexPlus1;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }
    }
}

