/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ItemStackFilter
implements Predicate<ItemStack>,
INBTSerializable<CompoundTag> {
    public static final String FILTER_KEY = "Filter";
    public static final String STRICT_KEY = "Strict";
    public static final ItemStackFilter ALLOW_ANY = new ItemStackFilter(null, false);
    public static final ItemStackFilter ALLOW_NONE = new ItemStackFilter(ItemStack.f_41583_, false);
    @Nullable
    private ItemStack filter;
    private boolean isStrict;

    protected ItemStackFilter(@Nullable ItemStack filter, boolean isStrict) {
        this.filter = filter;
        this.isStrict = isStrict;
    }

    protected ItemStackFilter(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public static ItemStackFilter of(CompoundTag tag) {
        return new ItemStackFilter(tag);
    }

    public static ItemStackFilter of(Item filter) {
        return ItemStackFilter.of(filter.m_7968_(), false);
    }

    public static ItemStackFilter of(@Nullable ItemStack filter) {
        return ItemStackFilter.of(filter, true);
    }

    private static ItemStackFilter of(@Nullable ItemStack filter, boolean isStrict) {
        if (filter == null) {
            return ALLOW_ANY;
        }
        if (filter.m_41619_()) {
            return ALLOW_NONE;
        }
        if ((filter = filter.m_255036_(1)).m_41782_()) {
            CompoundTag stackTag = filter.m_41783_();
            assert (stackTag != null);
            stackTag.m_128473_("Enchantments");
            stackTag.m_128473_("AttributeModifiers");
        }
        return new ItemStackFilter(filter, isStrict);
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (this.filter == null) {
            return true;
        }
        if (this.filter.m_41619_()) {
            return false;
        }
        if (this.isStrict) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)this.filter, (ItemStack)stack);
        }
        return this.filter.m_150930_(stack.m_41720_());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.filter != null) {
            tag.m_128365_(FILTER_KEY, (Tag)this.filter.serializeNBT());
            tag.m_128379_(STRICT_KEY, this.isStrict);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.filter = tag.m_128441_(FILTER_KEY) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(FILTER_KEY)) : null;
        this.isStrict = tag.m_128471_(STRICT_KEY);
    }

    public boolean allowsAny() {
        return this.filter == null;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.filter;
    }
}

