/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.random;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RandomSource;

public class DynamicWeightedRandomList<T extends IWeightedEntry<?>> {
    private final LinkedList<T> items;
    private int totalWeight = 0;

    protected DynamicWeightedRandomList(List<? extends T> items) {
        this.items = new LinkedList<T>(items);
        this.calcTotalWeight();
    }

    protected DynamicWeightedRandomList() {
        this.items = new LinkedList();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public List<T> getEntries() {
        return this.items;
    }

    protected void addEntry(T entry) {
        this.items.add(entry);
        this.calcTotalWeight();
    }

    protected void removeEntry(T entry) {
        this.items.remove(entry);
        this.calcTotalWeight();
    }

    protected Optional<T> getRandom(RandomSource random) {
        if (this.totalWeight == 0) {
            return Optional.empty();
        }
        return this.getWeightedItem(random.m_188503_(this.totalWeight));
    }

    protected Optional<T> getWeightedItem(int weightedIndex) {
        for (IWeightedEntry entry : this.items) {
            if ((weightedIndex -= entry.weight()) >= 0) continue;
            if (entry.shouldRemove()) {
                this.removeEntry(entry);
            }
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    protected void calcTotalWeight() {
        long sum = 0L;
        for (IWeightedEntry entry : this.items) {
            sum += (long)entry.weight();
        }
        if (sum > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        this.totalWeight = (int)sum;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface IWeightedEntry<E> {
        public E data();

        public int weight();

        default public boolean shouldRemove() {
            return false;
        }

        public record SelfRemoving<E>(E data, int weight) implements IWeightedEntry<E>
        {
            @Override
            public boolean shouldRemove() {
                return true;
            }
        }

        public record Default<E>(E data, int weight) implements IWeightedEntry<E>
        {
        }
    }
}

