/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world;

import com.github.elenterius.biomancy.block.DirectionalSlabBlock;
import com.github.elenterius.biomancy.block.FleshBlock;
import com.github.elenterius.biomancy.block.bloom.BloomBlock;
import com.github.elenterius.biomancy.block.property.DirectionalSlabType;
import com.github.elenterius.biomancy.block.veins.FleshVeinsBlock;
import com.github.elenterius.biomancy.entity.mob.fleshblob.FleshBlob;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.init.tags.ModBlockTags;
import com.github.elenterius.biomancy.util.LevelUtil;
import com.github.elenterius.biomancy.util.MobUtil;
import com.github.elenterius.biomancy.util.random.CellularNoise;
import com.github.elenterius.biomancy.util.random.CellularNoiseProvider;
import com.github.elenterius.biomancy.util.random.CellularNoiseWithDomainWarp;
import com.github.elenterius.biomancy.util.random.FastNoiseLite;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class PrimordialEcosystem {
    private static final RandomSource random = RandomSource.m_216327_();
    public static final IntSupplier MAX_CHARGE_SUPPLIER = () -> 15;
    public static final Set<Block> MALIGNANT_UPGRADE_TARGETS = Set.of((Block)ModBlocks.MALIGNANT_FLESH_SLAB.get(), (Block)ModBlocks.MALIGNANT_FLESH_STAIRS.get());
    public static final Set<Block> FULL_FLESH_BLOCKS = Set.of((Block)ModBlocks.MALIGNANT_FLESH.get(), (Block)ModBlocks.PRIMAL_FLESH.get(), (Block)ModBlocks.SMOOTH_PRIMAL_FLESH.get(), (Block)ModBlocks.POROUS_PRIMAL_FLESH.get(), (Block)ModBlocks.PRIMAL_PERMEABLE_MEMBRANE.get());
    public static final Set<Block> SOLID_FLESH_BLOCKS = Set.of((Block)ModBlocks.MALIGNANT_FLESH.get(), (Block)ModBlocks.PRIMAL_FLESH.get(), (Block)ModBlocks.SMOOTH_PRIMAL_FLESH.get(), (Block)ModBlocks.POROUS_PRIMAL_FLESH.get());

    private PrimordialEcosystem() {
    }

    public static void placeMalignantBlocksOnLivingDeath(ServerLevel level, LivingEntity livingEntity) {
        BlockPos pos = livingEntity.m_20097_().m_7494_();
        float volume = MobUtil.getVolume((Entity)livingEntity);
        float referenceVolume = MobUtil.getVolume(EntityType.f_20532_);
        float pct = volume / referenceVolume;
        if (!PrimordialEcosystem.placeMalignantBlocks(level, pos, livingEntity.m_217043_(), pct)) {
            BlockPos relativePos;
            for (int i = 0; i < 4 && !PrimordialEcosystem.placeMalignantBlocks(level, relativePos = pos.m_121945_(Direction.m_122407_((int)i)), livingEntity.m_217043_(), pct); ++i) {
            }
        }
    }

    public static boolean placeMalignantBlocks(ServerLevel level, BlockPos pos, RandomSource random, float chargePct) {
        BlockState stateForPlacement;
        FleshVeinsBlock veinsBlock;
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60713_((Block)(veinsBlock = (FleshVeinsBlock)((Object)ModBlocks.MALIGNANT_FLESH_VEINS.get())))) {
            if (veinsBlock.m_213612_().m_221657_(currentState, (LevelAccessor)level, pos, false) > 0L) {
                for (Direction subDirection : Direction.m_235667_((RandomSource)random)) {
                    BlockPos neighborPos = pos.m_121945_(subDirection);
                    BlockState neighborState = level.m_8055_(neighborPos);
                    veinsBlock.increaseCharge(level, neighborPos, neighborState, 1);
                }
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), SoundSource.BLOCKS, 1.0f, 0.15f + random.m_188501_() * 0.5f);
            } else {
                Block block = chargePct < 1.0f ? (Block)ModBlocks.MALIGNANT_FLESH_SLAB.get() : (Block)ModBlocks.MALIGNANT_FLESH.get();
                level.m_46597_(pos, block.m_49966_());
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.15f + random.m_188501_() * 0.5f);
            }
            return true;
        }
        if (currentState.m_60713_((Block)ModBlocks.MALIGNANT_FLESH_SLAB.get())) {
            if (currentState.m_61143_(DirectionalSlabBlock.TYPE) == DirectionalSlabType.FULL) {
                return false;
            }
            level.m_46597_(pos, ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_());
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.15f + level.f_46441_.m_188501_() * 0.5f);
            return true;
        }
        if (currentState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext((Level)level, pos, Direction.DOWN, ItemStack.f_41583_, Direction.UP)) && (stateForPlacement = veinsBlock.getStateForPlacement(currentState, (BlockGetter)level, pos, Direction.DOWN, Math.max(1, Mth.m_14167_((float)(chargePct * 15.0f))))) != null) {
            level.m_46597_(pos, stateForPlacement);
            if (random.m_188501_() < chargePct) {
                veinsBlock.m_213612_().m_221619_(stateForPlacement, (LevelAccessor)level, pos, random);
            }
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), SoundSource.BLOCKS, 0.7f, 0.15f + random.m_188501_() * 0.5f);
            return true;
        }
        return false;
    }

    public static <T extends FleshBlob> boolean placeMalignantBlocks(ServerLevel level, BlockPos pos, T fleshBlob) {
        BlockState stateForPlacement;
        BlockState currentState = level.m_8055_(pos);
        FleshVeinsBlock veinsBlock = (FleshVeinsBlock)((Object)ModBlocks.MALIGNANT_FLESH_VEINS.get());
        RandomSource random = fleshBlob.m_217043_();
        if (currentState.m_60713_((Block)veinsBlock)) {
            if (veinsBlock.m_213612_().m_221657_(currentState, (LevelAccessor)level, pos, false) > 0L) {
                for (Direction subDirection : Direction.m_235667_((RandomSource)random)) {
                    BlockPos neighborPos = pos.m_121945_(subDirection);
                    BlockState neighborState = level.m_8055_(neighborPos);
                    veinsBlock.increaseCharge(level, neighborPos, neighborState, 1);
                }
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), SoundSource.BLOCKS, 1.0f, 0.15f + random.m_188501_() * 0.5f);
            } else {
                Block block = (float)fleshBlob.getBlobSize() < 5.0f ? (Block)ModBlocks.MALIGNANT_FLESH_SLAB.get() : (Block)ModBlocks.MALIGNANT_FLESH.get();
                level.m_46597_(pos, block.m_49966_());
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.15f + random.m_188501_() * 0.5f);
            }
            return true;
        }
        if (currentState.m_60713_((Block)ModBlocks.MALIGNANT_FLESH_SLAB.get())) {
            if (currentState.m_61143_(DirectionalSlabBlock.TYPE) == DirectionalSlabType.FULL) {
                return false;
            }
            level.m_46597_(pos, ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_());
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.15f + level.f_46441_.m_188501_() * 0.5f);
            return true;
        }
        if (currentState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext((Level)level, pos, Direction.DOWN, ItemStack.f_41583_, Direction.UP)) && (stateForPlacement = veinsBlock.getStateForPlacement(currentState, (BlockGetter)level, pos, Direction.DOWN, fleshBlob.getBlobSize() * 2)) != null) {
            level.m_46597_(pos, stateForPlacement);
            if (random.m_188501_() < (float)fleshBlob.getBlobSize() / 10.0f) {
                veinsBlock.m_213612_().m_221619_(stateForPlacement, (LevelAccessor)level, pos, random);
            }
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), SoundSource.BLOCKS, 0.7f, 0.15f + random.m_188501_() * 0.5f);
            return true;
        }
        return false;
    }

    public static boolean placeBloomOrBlocks(ServerLevel level, BlockPos pos, Direction direction) {
        FleshVeinsBlock veinsBlock;
        BlockState stateForPlacement;
        BlockState state = level.m_8055_(pos);
        if (MALIGNANT_UPGRADE_TARGETS.contains(state.m_60734_())) {
            level.m_7731_(pos, ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_(), 2);
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.15f + level.f_46441_.m_188501_() * 0.5f);
            return true;
        }
        BlockPos relativePos = pos.m_121945_(direction);
        BlockState relativeState = level.m_8055_(relativePos);
        RandomSource random = level.m_213780_();
        if (random.m_188501_() < 0.7f && ((BloomBlock)((Object)ModBlocks.PRIMAL_BLOOM.get())).mayPlaceOn((BlockGetter)level, pos, state, direction)) {
            boolean noBloomNearby;
            boolean canBeReplaced = relativeState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext((Level)level, relativePos, direction.m_122424_(), ItemStack.f_41583_, direction));
            boolean bl = noBloomNearby = !LevelUtil.isBlockNearby(level, pos, 4, blockState -> blockState.m_60713_((Block)ModBlocks.PRIMAL_BLOOM.get()));
            if (canBeReplaced && noBloomNearby) {
                BlockState blockState2 = ((BloomBlock)((Object)ModBlocks.PRIMAL_BLOOM.get())).getStateForPlacement((BlockGetter)level, relativePos, direction);
                level.m_5594_(null, relativePos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.5f + random.m_188501_() * 0.5f);
                level.m_7731_(relativePos, blockState2, 2);
                return true;
            }
        }
        if (relativeState.m_60713_((Block)ModBlocks.MALIGNANT_FLESH_VEINS.get())) {
            if (PrimordialEcosystem.tryToReplaceBlock(level, relativePos, ((FleshBlock)((Object)ModBlocks.PRIMAL_FLESH.get())).m_49966_())) {
                level.m_5594_(null, relativePos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), SoundSource.BLOCKS, 1.0f, 0.15f + random.m_188501_() * 0.5f);
                return true;
            }
            if (FleshVeinsBlock.convert(relativeState, level, relativePos, 0, null, 0.5f, null)) {
                level.m_5594_(null, relativePos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_PLACE.get(), SoundSource.BLOCKS, 1.0f, 0.15f + random.m_188501_() * 0.5f);
                return true;
            }
            return PrimordialEcosystem.spreadMalignantVeinsFromSource(level, relativePos, MAX_CHARGE_SUPPLIER);
        }
        if (relativeState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext((Level)level, relativePos, direction.m_122424_(), ItemStack.f_41583_, direction)) && (stateForPlacement = (veinsBlock = (FleshVeinsBlock)((Object)ModBlocks.MALIGNANT_FLESH_VEINS.get())).getStateForPlacement(relativeState, (BlockGetter)level, relativePos, direction.m_122424_(), 15)) != null) {
            level.m_7731_(relativePos, stateForPlacement, 2);
            for (int i = 0; i < 4; ++i) {
                if (!(random.m_188501_() < 0.4f)) continue;
                veinsBlock.m_213612_().m_221619_(stateForPlacement, (LevelAccessor)level, relativePos, random);
            }
            level.m_5594_(null, relativePos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), SoundSource.BLOCKS, 0.7f, 0.15f + random.m_188501_() * 0.5f);
            return true;
        }
        return false;
    }

    public static boolean spreadMalignantVeinsFromSource(ServerLevel level, BlockPos pos, IntSupplier chargeSupplier) {
        FleshVeinsBlock veinsBlock = (FleshVeinsBlock)((Object)ModBlocks.MALIGNANT_FLESH_VEINS.get());
        BlockState state = level.m_8055_(pos);
        RandomSource random = level.f_46441_;
        boolean hasPlacedVeins = false;
        for (int i = 0; i < 4; ++i) {
            Optional spreadPos;
            if (!(random.m_188501_() < 0.6f) || !(spreadPos = veinsBlock.m_213612_().m_221619_(state, (LevelAccessor)level, pos, random)).isPresent()) continue;
            hasPlacedVeins = true;
        }
        PrimordialEcosystem.increaseMalignantVeinsChargeAroundPos(level, pos, chargeSupplier);
        return hasPlacedVeins;
    }

    public static int increaseMalignantVeinsChargeAroundPos(ServerLevel level, BlockPos pos, IntSupplier chargeSupplier) {
        FleshVeinsBlock veinsBlock = (FleshVeinsBlock)((Object)ModBlocks.MALIGNANT_FLESH_VEINS.get());
        int usedCharge = 0;
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos neighborPos = pos.m_7918_(x, y, z);
                    BlockState neighborState = level.m_8055_(neighborPos);
                    usedCharge += veinsBlock.increaseCharge(level, neighborPos, neighborState, chargeSupplier.getAsInt());
                }
            }
        }
        return usedCharge;
    }

    public static int countMalignantChargeAroundPos(ServerLevel level, BlockPos pos) {
        int totalCharge = 0;
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos neighborPos = pos.m_7918_(x, y, z);
                    BlockState neighborState = level.m_8055_(neighborPos);
                    totalCharge += neighborState.m_61145_((Property)ModBlockProperties.CHARGE.get()).orElse(0).intValue();
                }
            }
        }
        return totalCharge;
    }

    public static int countMalignantVeinsAroundPos(ServerLevel level, BlockPos pos) {
        int veins = 0;
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0 || !level.m_8055_(pos.m_7918_(x, y, z)).m_60713_((Block)ModBlocks.MALIGNANT_FLESH_VEINS.get())) continue;
                    ++veins;
                }
            }
        }
        return veins;
    }

    private static double step(double value, double threshold) {
        return value >= threshold ? 1.0 : 0.0;
    }

    public static void generateHollowVoronoiSphere(ServerLevel level, BlockPos pos, int radius, BlockState state) {
        CellularNoise noise = PrimordialEcosystem.createPreconfiguredCellularNoise((int)Mth.m_14057_((Vec3i)pos));
        int i = 0;
        while (i <= radius) {
            int currRadius = radius - Math.abs(i) / 2;
            int x = -currRadius;
            int z = 0;
            int error = 2 - 2 * currRadius;
            do {
                PrimordialEcosystem.trySetBlock(level, pos, state, noise, -x, i, z);
                PrimordialEcosystem.trySetBlock(level, pos, state, noise, -z, i, -x);
                PrimordialEcosystem.trySetBlock(level, pos, state, noise, x, i, -z);
                PrimordialEcosystem.trySetBlock(level, pos, state, noise, z, i, x);
                currRadius = error;
                if (currRadius <= z) {
                    error += ++z * 2 + 1;
                }
                if (currRadius <= x && error <= z) continue;
                error += ++x * 2 + 1;
            } while (x < 0);
            i = i > 0 ? -i : 1 - i;
        }
    }

    private static void trySetBlockInCellularLevel(ServerLevel level, BlockPos pos, BlockState placementState, int x, int y, int z) {
        CellularNoise noise = PrimordialEcosystem.getCellularNoise(level);
        float borderThreshold = 0.15f;
        float n = noise.getValue((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        if (n >= borderThreshold) {
            PrimordialEcosystem.tryToReplaceBlock(level, pos.m_7918_(x, y, z), placementState);
        }
    }

    private static void trySetBlock(ServerLevel level, BlockPos pos, BlockState placementState, CellularNoise noise, int x, int y, int z) {
        float borderThreshold = 0.12f;
        float n = noise.getValue((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        if (n >= borderThreshold) {
            PrimordialEcosystem.tryToReplaceBlock(level, pos.m_7918_(x, y, z), placementState);
        }
    }

    public static boolean tryToReplaceBlock(ServerLevel level, BlockPos pos, BlockState replacementState) {
        BlockState state = level.m_8055_(pos);
        if (PrimordialEcosystem.isReplaceable(state)) {
            level.m_7731_(pos, replacementState, 2);
            return true;
        }
        return false;
    }

    public static boolean tryToReplaceBlock(ServerLevel level, BlockPos pos, BlockState state, BlockState replacementState) {
        if (PrimordialEcosystem.isReplaceable(state)) {
            level.m_7731_(pos, replacementState, 2);
            return true;
        }
        return false;
    }

    public static boolean tryToReplaceBlock(ServerLevel level, BlockPos pos, BlockState state, Supplier<BlockState> replacementStateSupplier) {
        if (PrimordialEcosystem.isReplaceable(state)) {
            level.m_7731_(pos, replacementStateSupplier.get(), 2);
            return true;
        }
        return false;
    }

    public static boolean isReplaceable(BlockState state) {
        return state.m_247087_() || state.m_204336_(ModBlockTags.FLESH_REPLACEABLE);
    }

    public static boolean isReplaceableLog(BlockState state) {
        return PrimordialEcosystem.isReplaceable(state) && state.m_204336_(BlockTags.f_215839_);
    }

    public static RandomSource getRandomWithSeed(BlockPos pos) {
        random.m_188584_(Mth.m_14057_((Vec3i)pos));
        return random;
    }

    public static CellularNoise getCellularNoise(ServerLevel level) {
        return ((CellularNoiseProvider)level).biomancy$getCellularNoise();
    }

    public static CellularNoise createPreconfiguredCellularNoise(int seed) {
        FastNoiseLite cellularNoise = new FastNoiseLite(seed);
        cellularNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
        cellularNoise.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
        cellularNoise.SetFrequency(0.05f);
        FastNoiseLite domainWarp = new FastNoiseLite(seed);
        domainWarp.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2Reduced);
        domainWarp.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
        domainWarp.SetDomainWarpAmp(50.0f);
        domainWarp.SetFrequency(0.005f);
        return new CellularNoiseWithDomainWarp(cellularNoise, domainWarp, 0.16f, 0.13f);
    }
}

