/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial.geometry;

import com.github.elenterius.biomancy.util.serialization.NBTSerializer;
import com.github.elenterius.biomancy.world.spatial.geometry.GeometryUtil;
import com.github.elenterius.biomancy.world.spatial.geometry.HasRadius;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import com.github.elenterius.biomancy.world.spatial.type.ShapeSerializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OctantEllipsoidShape
implements Shape,
HasRadius {
    private final Vec3 center;
    private final float radius;
    private final Vec3 origin;
    private final float aPos;
    private final float bPos;
    private final float cPos;
    private final float aNeg;
    private final float bNeg;
    private final float cNeg;

    public OctantEllipsoidShape(Vec3 pos, float aPos, float bPos, float cPos, float aNeg, float bNeg, float cNeg) {
        this.origin = pos;
        this.aPos = aPos;
        this.bPos = bPos;
        this.cPos = cPos;
        this.aNeg = aNeg;
        this.bNeg = bNeg;
        this.cNeg = cNeg;
        Vec3 min = new Vec3(this.origin.f_82479_ - (double)aNeg, this.origin.f_82480_ - (double)bNeg, this.origin.f_82481_ - (double)cNeg);
        Vec3 max = new Vec3(this.origin.f_82479_ + (double)aPos, this.origin.f_82480_ + (double)bPos, this.origin.f_82481_ + (double)cPos);
        this.center = min.m_165921_(max, 0.5);
        float a = (aPos + aNeg) / 2.0f;
        float b = (bPos + bNeg) / 2.0f;
        float c = (cPos + cNeg) / 2.0f;
        this.radius = Math.max(Math.max(a, b), c);
    }

    public OctantEllipsoidShape(double x, double y, double z, float aPos, float bPos, float cPos, float aNeg, float bNeg, float cNeg) {
        this(new Vec3(x, y, z), aPos, bPos, cPos, aNeg, bNeg, cNeg);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        double dx = this.origin.f_82479_ - x;
        double dy = this.origin.f_82480_ - y;
        double dz = this.origin.f_82481_ - z;
        return (dx /= dx <= 0.0 ? (double)this.aPos : (double)this.aNeg) * dx + (dy /= dy <= 0.0 ? (double)this.bPos : (double)this.bNeg) * dy + (dz /= dz <= 0.0 ? (double)this.cPos : (double)this.cNeg) * dz < 1.0;
    }

    @Override
    public boolean intersectsCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vec3 closestPoint = GeometryUtil.closestPointOnAABB(minX, minY, minZ, maxX, maxY, maxZ, this.origin);
        return this.contains(closestPoint.f_82479_, closestPoint.f_82480_, closestPoint.f_82481_);
    }

    @Override
    public Vec3 center() {
        return this.center;
    }

    @Override
    public double distanceToSqr(double x, double y, double z) {
        return this.center.m_82531_(x, y, z);
    }

    @Override
    public AABB getAABB() {
        return new AABB(this.origin.f_82479_ - (double)this.aNeg, this.origin.f_82480_ - (double)this.bNeg, this.origin.f_82481_ - (double)this.cNeg, this.origin.f_82479_ + (double)this.aPos, this.origin.f_82480_ + (double)this.bPos, this.origin.f_82481_ + (double)this.cPos);
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public NBTSerializer<Shape> getNBTSerializer() {
        return ShapeSerializers.OCTANT_ELLIPSOID_SERIALIZER;
    }

    public record Serializer(String id) implements NBTSerializer<OctantEllipsoidShape>
    {
        @Override
        public CompoundTag write(OctantEllipsoidShape shape) {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("X", shape.origin.f_82479_);
            tag.m_128347_("Y", shape.origin.f_82480_);
            tag.m_128347_("Z", shape.origin.f_82481_);
            tag.m_128350_("A+", shape.aPos);
            tag.m_128350_("B+", shape.bPos);
            tag.m_128350_("C+", shape.cPos);
            tag.m_128350_("A-", shape.aNeg);
            tag.m_128350_("B-", shape.bNeg);
            tag.m_128350_("C-", shape.cNeg);
            return tag;
        }

        @Override
        public OctantEllipsoidShape read(CompoundTag tag) {
            double x = tag.m_128459_("X");
            double y = tag.m_128459_("Y");
            double z = tag.m_128459_("Z");
            float aPos = tag.m_128457_("A+");
            float bPos = tag.m_128457_("B+");
            float cPos = tag.m_128457_("C+");
            float aNeg = tag.m_128457_("A-");
            float bNeg = tag.m_128457_("B-");
            float cNeg = tag.m_128457_("C-");
            return new OctantEllipsoidShape(x, y, z, aPos, bPos, cPos, aNeg, bNeg, cNeg);
        }
    }
}

