/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial.type;

import com.github.elenterius.biomancy.util.serialization.NBTSerializer;
import com.github.elenterius.biomancy.world.MobSpawnFilterShape;
import com.github.elenterius.biomancy.world.mound.MoundShape;
import com.github.elenterius.biomancy.world.spatial.geometry.CuboidShape;
import com.github.elenterius.biomancy.world.spatial.geometry.OctantEllipsoidShape;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import com.github.elenterius.biomancy.world.spatial.geometry.SphereShape;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class ShapeSerializers {
    private static final Map<String, NBTSerializer<Shape>> SERIALIZERS = new HashMap<String, NBTSerializer<Shape>>();
    public static final NBTSerializer<Shape> CUBOID_SERIALIZER = ShapeSerializers.register("cuboid", CuboidShape.Serializer::new);
    public static final NBTSerializer<Shape> SPHERE_SERIALIZER = ShapeSerializers.register("sphere", SphereShape.Serializer::new);
    public static final NBTSerializer<Shape> OCTANT_ELLIPSOID_SERIALIZER = ShapeSerializers.register("octant_ellipsoid", OctantEllipsoidShape.Serializer::new);
    public static final NBTSerializer<Shape> MOUND_SERIALIZER = ShapeSerializers.register("mound", MoundShape.Serializer::new);
    public static final NBTSerializer<Shape> MOB_SPAWN_FILTER_SERIALIZER = ShapeSerializers.register("mob_spawn_filter", MobSpawnFilterShape.Serializer::new);

    private ShapeSerializers() {
    }

    public static <T extends Shape> NBTSerializer<Shape> register(String id, Factory<T> factory) {
        NBTSerializer<Shape> serializer = ShapeSerializers.cast(factory.create(id));
        SERIALIZERS.put(id, serializer);
        return serializer;
    }

    @Nullable
    public static NBTSerializer<Shape> get(String id) {
        return SERIALIZERS.get(id);
    }

    private static NBTSerializer<Shape> cast(NBTSerializer<? extends Shape> serializer) {
        return serializer;
    }

    @FunctionalInterface
    public static interface Factory<T extends Shape> {
        public NBTSerializer<T> create(String var1);
    }
}

