/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.block;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class CrabEggBlock
extends Block {
    private static final VoxelShape SMALL_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape LARGE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty EGGS = BlockStateProperties.f_61415_;

    public CrabEggBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_20161_()) {
            this.tryBreakEgg(world, state, pos, entity, 100);
        }
        super.m_141947_(world, pos, state, entity);
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!(entity instanceof Zombie)) {
            this.tryBreakEgg(world, state, pos, entity, 3);
        }
        super.m_142072_(world, state, pos, entity, fallDistance);
    }

    private void tryBreakEgg(Level world, BlockState state, BlockPos pos, Entity entity, int inverseChance) {
        if (this.breaksEgg(world, entity) && !world.m_5776_() && world.m_213780_().m_188503_(inverseChance) == 0 && state.m_60713_(FriendsAndFoesBlocks.CRAB_EGG.get())) {
            this.breakEgg(world, pos, state);
        }
    }

    private void breakEgg(Level world, BlockPos pos, BlockState state) {
        world.m_5594_(null, pos, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + world.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)state.m_61143_((Property)EGGS);
        if (i <= 1) {
            world.m_46961_(pos, false);
        } else {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            world.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.shouldHatchProgress((Level)world) && CrabEggBlock.isSuitableBelow((BlockGetter)world, pos)) {
            int i = (Integer)state.m_61143_((Property)HATCH);
            if (i < 2) {
                world.m_5594_(null, pos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                world.m_5594_(null, pos, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                world.m_7471_(pos, false);
                for (int j = 0; j < (Integer)state.m_61143_((Property)EGGS); ++j) {
                    world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    CrabEntity crab = (CrabEntity)FriendsAndFoesEntityTypes.CRAB.get().m_20615_((Level)world);
                    crab.m_146762_(-24000);
                    crab.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
                    world.m_7967_((Entity)crab);
                }
            }
        }
    }

    public static boolean isSuitableBelow(BlockGetter world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_204336_(FriendsAndFoesTags.CRAB_BURROW_SPOT_BLOCKS);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (CrabEggBlock.isSuitableBelow((BlockGetter)world, pos) && !world.m_5776_()) {
            world.m_46796_(2005, pos, 0);
        }
    }

    private boolean shouldHatchProgress(Level world) {
        float f = world.m_46942_(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return world.f_46441_.m_188503_(500) == 0;
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.m_6240_(world, player, pos, state, blockEntity, stack);
        this.breakEgg(world, pos, state);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)EGGS) < 4 || super.m_6864_(state, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_());
        return blockState.m_60713_((Block)this) ? (BlockState)blockState.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockState.m_61143_((Property)EGGS) + 1))) : super.m_5573_(ctx);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)EGGS) > 1 ? LARGE_SHAPE : SMALL_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HATCH, EGGS});
    }

    private boolean breaksEgg(Level world, Entity entity) {
        if (!(entity instanceof CrabEntity) && !(entity instanceof Bat)) {
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            return entity instanceof Player || world.m_46469_().m_46207_(GameRules.f_46132_);
        }
        return false;
    }
}

