/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.entity.BlazeEntityAccess;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.mixin.BlazeLivingEntityMixin;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Blaze.class})
public abstract class BlazeEntityMixin
extends BlazeLivingEntityMixin
implements BlazeEntityAccess {
    private static final String WILDFIRE_UUID_NBT_NAME = "WildfireUuid";
    private Optional<UUID> friendsandfoes_wildfireUuid = Optional.empty();

    protected BlazeEntityMixin(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void friendsandfoes_writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        if (this.friendsandfoes_getWildfireUuid() != null) {
            nbt.m_128362_(WILDFIRE_UUID_NBT_NAME, this.friendsandfoes_getWildfireUuid());
        }
    }

    @Override
    public void friendsandfoes_readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128403_(WILDFIRE_UUID_NBT_NAME)) {
            this.friendsandfoes_setWildfireUuid(nbt.m_128342_(WILDFIRE_UUID_NBT_NAME));
        }
    }

    @Override
    public void friendsandfoes_onDeath(DamageSource damageSource, CallbackInfo ci) {
        WildfireEntity wildfireEntity;
        if (this.m_9236_() instanceof ServerLevel && (wildfireEntity = this.friendsandfoes_getWildfire()) != null) {
            wildfireEntity.setSummonedBlazesCount(wildfireEntity.getSummonedBlazesCount() - 1);
        }
    }

    @Nullable
    public UUID friendsandfoes_getWildfireUuid() {
        return this.friendsandfoes_wildfireUuid.orElse(null);
    }

    public void friendsandfoes_setWildfireUuid(@Nullable UUID uuid) {
        this.friendsandfoes_wildfireUuid = Optional.ofNullable(uuid);
    }

    @Override
    public void friendsandfoes_setWildfire(WildfireEntity wildfire) {
        this.friendsandfoes_setWildfireUuid(wildfire.m_20148_());
    }

    @Override
    @Nullable
    public WildfireEntity friendsandfoes_getWildfire() {
        try {
            ServerLevel serverWorld = (ServerLevel)this.m_9236_();
            UUID uUID = this.friendsandfoes_getWildfireUuid();
            return uUID == null ? null : (WildfireEntity)serverWorld.m_8791_(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }
}

