/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.data;

import com.google.common.collect.Table;
import java.util.function.Consumer;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.block.entities.ChiseledBlockEntity;
import mod.chiselsandbits.client.model.data.ChiseledBlockModelDataExecutor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockModelDataManager {
    private static final Runnable NOOP = () -> {};
    private static final ChiseledBlockModelDataManager INSTANCE = new ChiseledBlockModelDataManager();

    public static ChiseledBlockModelDataManager getInstance() {
        return INSTANCE;
    }

    private ChiseledBlockModelDataManager() {
    }

    public void updateModelData(@Nullable ChiseledBlockEntity tileEntity) {
        this.updateModelData(tileEntity, NOOP, false);
    }

    public void updateModelData(ChiseledBlockEntity tileEntity, Runnable onCompleteCallback, boolean force) {
        if (!(force || tileEntity.m_58898_() && tileEntity.m_58904_().m_5776_() && tileEntity != null)) {
            return;
        }
        ChiseledBlockModelDataExecutor.updateModelDataCore(tileEntity, onCompleteCallback);
    }

    public void computeModelsSplit(ChiseledBlockEntity tileEntity, Consumer<Table<RenderType, IBlockInformation, BakedModel>> onCompleteCallback, boolean force) {
        if (!(force || tileEntity.m_58898_() && tileEntity.m_58904_().m_5776_() && tileEntity != null)) {
            return;
        }
        ChiseledBlockModelDataExecutor.updateModelDataPerContainedState(tileEntity, onCompleteCallback);
    }
}

