/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.compat.create;

import com.communi.suggestu.scena.core.client.models.data.IBlockModelData;
import com.google.common.collect.Maps;
import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.model.BlockModel;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.forge.compat.create.ChiseledBlockMaterials;
import mod.chiselsandbits.forge.compat.create.ChiseledBlockOnContraptionModelCache;
import mod.chiselsandbits.registrars.ModModelProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public class ChiseledBlockInstance {
    private final MaterialManager materialManager;
    private final BlockState blockState;
    private final BlockPos instancePos;
    private Map<RenderType, ModelData> modelData = Maps.newConcurrentMap();
    private int localBlockLight = -1;

    public ChiseledBlockInstance(MaterialManager materialManager, BlockState blockState, BlockPos instancePos, ChiseledBlockOnContraptionModelCache cache) {
        this.materialManager = materialManager;
        this.blockState = blockState;
        this.instancePos = instancePos;
        cache.addConsumer((identifier, modelData) -> Minecraft.m_91087_().execute(() -> this.init((IAreaShapeIdentifier)identifier, (IBlockModelData)modelData)));
    }

    public void init(IAreaShapeIdentifier identifier, IBlockModelData data) {
        Map models = (Map)data.getData(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY);
        if (models == null) {
            return;
        }
        Set<RenderType> removedTypes = this.modelData.keySet().stream().filter(t -> !models.containsKey(t)).collect(Collectors.toSet());
        removedTypes.forEach(key -> {
            this.modelData.get(key).delete();
            this.modelData.remove(key);
        });
        models.forEach((renderType, model) -> {
            record ModelKey(IAreaShapeIdentifier identifier, RenderType type) {
            }
            RenderLayer layer = RenderLayer.getLayer((RenderType)renderType);
            if (layer == null) {
                return;
            }
            if (!this.modelData.containsKey(renderType)) {
                this.modelData.put((RenderType)renderType, (ModelData)this.materialManager.state(layer, renderType).material(ChiseledBlockMaterials.CHISELED_BLOCK).model((Object)new ModelKey(identifier, (RenderType)renderType), () -> BlockModel.of((BakedModel)model, (BlockState)this.blockState)).createInstance());
                if (this.localBlockLight != -1) {
                    this.modelData.get(renderType).setBlockLight(this.localBlockLight);
                }
            } else {
                this.materialManager.state(layer, renderType).material(ChiseledBlockMaterials.CHISELED_BLOCK).model((Object)new ModelKey(identifier, (RenderType)renderType), () -> BlockModel.of((BakedModel)model, (BlockState)this.blockState)).stealInstance((InstanceData)this.modelData.get(renderType));
            }
        });
    }

    public void beginFrame() {
        if (this.modelData != null) {
            for (ModelData value : this.modelData.values()) {
                value.loadIdentity().translate((Vec3i)this.instancePos);
            }
        }
    }

    public void setInitialBlockLight(int localBlockLight) {
        this.localBlockLight = localBlockLight;
    }
}

