/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blocks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.ITabExpander;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.module.CapabilityModuleSupport;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.compat.waila.WailaInfoProvider;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.multipart.IPartBlock;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.Tools;
import mcjty.lib.varia.WrenchChecker;
import mcjty.lib.varia.WrenchUsage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class BaseBlock
extends Block
implements WailaInfoProvider,
TOPInfoProvider,
IPartBlock,
ITooltipSettings,
EntityBlock,
ITabExpander {
    private final boolean infusable;
    private final BlockEntityType.BlockEntitySupplier<BlockEntity> tileEntitySupplier;
    private final TooltipBuilder tooltipBuilder;
    private final TOPDriver topDriver;
    private final ManualEntry manualEntry;
    public static final Property<?>[] HORIZ_PROPERTIES = new Property[]{BlockStateProperties.f_61374_};
    public static final Property<?>[] ROTATING_PROPERTIES = new Property[]{BlockStateProperties.f_61372_};
    public static final Property<?>[] NONE_PROPERTIES = new Property[0];

    public BaseBlock(BlockBuilder builder) {
        super(builder.getProperties());
        this.infusable = builder.isInfusable();
        this.tileEntitySupplier = builder.getTileEntitySupplier();
        this.tooltipBuilder = builder.getTooltipBuilder();
        this.topDriver = builder.getTopDriver();
        this.manualEntry = builder.getManualEntry();
    }

    @Override
    public ManualEntry getManualEntry() {
        return this.manualEntry;
    }

    public static void setInfused(ItemStack stack, int infused) {
        NBTTools.setInfoNBT(stack, CompoundTag::m_128405_, "infused", infused);
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag advanced) {
        this.intAddInformation(stack, tooltip);
        if (this.tooltipBuilder.isActive()) {
            this.tooltipBuilder.makeTooltip(Tools.getId(this), stack, tooltip, advanced);
        }
    }

    private void intAddInformation(ItemStack itemStack, List<Component> list) {
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound != null) {
            if (tagCompound.m_128441_("Energy")) {
                long energy = tagCompound.m_128454_("Energy");
                list.add((Component)ComponentFactory.literal(ChatFormatting.GREEN + "Energy: " + energy + " rf"));
            }
            if (this.isInfusable()) {
                int infused = BaseBlock.getInfused(itemStack);
                int pct = infused * 100 / (Integer)GeneralConfig.maxInfuse.get();
                list.add((Component)ComponentFactory.literal(ChatFormatting.YELLOW + "Infused: " + pct + "%"));
            }
            if (((Boolean)GeneralConfig.manageOwnership.get()).booleanValue() && tagCompound.m_128441_("owner")) {
                String owner = tagCompound.m_128461_("owner");
                int securityChannel = -1;
                if (tagCompound.m_128441_("secChannel")) {
                    securityChannel = tagCompound.m_128451_("secChannel");
                }
                if (securityChannel == -1) {
                    list.add((Component)ComponentFactory.literal(ChatFormatting.YELLOW + "Owned by: " + owner));
                } else {
                    list.add((Component)ComponentFactory.literal(ChatFormatting.YELLOW + "Owned by: " + owner + " (channel " + securityChannel + ")"));
                }
                if (!tagCompound.m_128441_("idM")) {
                    list.add((Component)ComponentFactory.literal(ChatFormatting.RED + "Warning! Ownership not correctly set! Please place block again!"));
                }
            }
        }
    }

    public static int getInfused(ItemStack itemStack) {
        return NBTTools.getInfoNBT(itemStack, CompoundTag::m_128451_, "infused", 0);
    }

    private WrenchUsage testWrenchUsage(BlockPos pos, Player player) {
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        WrenchUsage wrenchUsed = WrenchUsage.NOT;
        if (!itemStack.m_41619_()) {
            Item item = itemStack.m_41720_();
            wrenchUsed = this.getWrenchUsage(pos, player, itemStack, wrenchUsed, item);
        }
        if (wrenchUsed == WrenchUsage.NORMAL && player.m_6144_()) {
            wrenchUsed = WrenchUsage.SNEAKING;
        }
        return wrenchUsed;
    }

    protected WrenchUsage getWrenchUsage(BlockPos pos, Player player, ItemStack itemStack, WrenchUsage wrenchUsed, Item item) {
        if (item instanceof SmartWrench) {
            SmartWrench wrench = (SmartWrench)item;
            return switch (wrench.getMode(itemStack)) {
                default -> throw new IncompatibleClassChangeError();
                case SmartWrenchMode.MODE_WRENCH -> WrenchUsage.NORMAL;
                case SmartWrenchMode.MODE_SELECT -> player.m_6144_() ? WrenchUsage.SNEAK_SELECT : WrenchUsage.SELECT;
            };
        }
        if (WrenchChecker.isAWrench(item)) {
            return WrenchUsage.NORMAL;
        }
        return wrenchUsed;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        GenericTileEntity genTileEntity;
        InteractionResult resultType;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof GenericTileEntity && (resultType = (genTileEntity = (GenericTileEntity)te).onBlockActivated(state, player, hand, result)) != InteractionResult.PASS) {
            return resultType;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (this.handleModule(world, pos, state, player, hand, heldItem, result)) {
            return InteractionResult.SUCCESS;
        }
        WrenchUsage wrenchUsed = this.testWrenchUsage(pos, player);
        return switch (wrenchUsed) {
            default -> throw new IncompatibleClassChangeError();
            case WrenchUsage.NOT -> {
                if (this.openGui(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player)) {
                    yield InteractionResult.SUCCESS;
                }
                yield InteractionResult.PASS;
            }
            case WrenchUsage.NORMAL -> {
                if (this.wrenchUse(world, pos, result.m_82434_(), player)) {
                    yield InteractionResult.SUCCESS;
                }
                yield InteractionResult.PASS;
            }
            case WrenchUsage.SNEAKING -> {
                if (this.wrenchSneak(world, pos, player)) {
                    yield InteractionResult.SUCCESS;
                }
                yield InteractionResult.PASS;
            }
            case WrenchUsage.DISABLED -> {
                if (this.wrenchDisabled(world, pos, player)) {
                    yield InteractionResult.SUCCESS;
                }
                yield InteractionResult.PASS;
            }
            case WrenchUsage.SELECT -> {
                if (this.wrenchSelect(world, pos, player)) {
                    yield InteractionResult.SUCCESS;
                }
                yield InteractionResult.PASS;
            }
            case WrenchUsage.SNEAK_SELECT -> this.wrenchSneakSelect(world, pos, player) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        };
    }

    public boolean handleModule(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult result) {
        BlockEntity te;
        if (!heldItem.m_41619_() && (te = world.m_7702_(pos)) != null) {
            return te.getCapability(CapabilityModuleSupport.MODULE_CAPABILITY).map(h -> {
                if (h.isModule(heldItem)) {
                    return ModuleTools.installModule(player, heldItem, hand, pos, h.getFirstSlot(), h.getLastSlot());
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    protected boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof GenericTileEntity) {
            GenericTileEntity genTileEntity = (GenericTileEntity)tileEntity;
            if (!genTileEntity.wrenchUse(world, pos, side, player)) {
                BlockState state = this.rotate(world.m_8055_(pos), (LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
                world.m_7731_(pos, state, 3);
            }
        } else {
            BlockState state = this.rotate(world.m_8055_(pos), (LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
            world.m_7731_(pos, state, 3);
        }
        return true;
    }

    protected boolean wrenchSneak(Level world, BlockPos pos, Player player) {
        this.breakAndRemember(world, player, pos);
        return true;
    }

    protected void breakAndRemember(Level world, Player player, BlockPos pos) {
        if (!world.f_46443_) {
            this.m_6240_(world, player, pos, world.m_8055_(pos), world.m_7702_(pos), ItemStack.f_41583_);
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    protected boolean wrenchDisabled(Level world, BlockPos pos, Player player) {
        return false;
    }

    protected boolean wrenchSelect(Level world, BlockPos pos, Player player) {
        return false;
    }

    protected boolean wrenchSneakSelect(Level world, BlockPos pos, Player player) {
        return false;
    }

    protected boolean openGui(Level world, int x, int y, int z, Player player) {
        BlockEntity te = world.m_7702_(new BlockPos(x, y, z));
        if (te == null) {
            return false;
        }
        return te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> {
            if (world.f_46443_) {
                return true;
            }
            if (this.checkAccess(world, player, te)) {
                return true;
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)h, (BlockPos)te.m_58899_());
            return true;
        }).orElse(false);
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity te;
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.f_46443_ && ((Boolean)GeneralConfig.manageOwnership.get()).booleanValue()) {
            this.setOwner(world, pos, placer);
        }
        if ((te = world.m_7702_(pos)) instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onBlockPlacedBy(world, pos, state, placer, stack);
        }
        this.checkRedstone(world, pos);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        this.checkRedstone(world, pos);
    }

    protected void checkRedstone(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.checkRedstone(world, pos);
        }
    }

    protected void setOwner(Level world, BlockPos pos, LivingEntity entity) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                genericTileEntity.setOwner(player);
            }
        }
    }

    public boolean m_8133_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, int id, int param) {
        if (this.hasTileEntitySupplier()) {
            super.m_8133_(state, worldIn, pos, id, param);
            BlockEntity tileentity = worldIn.m_7702_(pos);
            return tileentity != null && tileentity.m_7531_(id, param);
        }
        return super.m_8133_(state, worldIn, pos, id, param);
    }

    protected boolean checkAccess(Level world, Player player, BlockEntity te) {
        if (te instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.checkAccess(player);
        }
        return false;
    }

    protected boolean hasTileEntitySupplier() {
        return this.tileEntitySupplier != null;
    }

    public RotationType getRotationType() {
        return RotationType.ROTATION;
    }

    public boolean isInfusable() {
        return this.infusable;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (this.hasTileEntitySupplier()) {
            return this.tileEntitySupplier.m_155267_(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BaseBlock::runTick;
    }

    public static void runTick(Level world, BlockPos blockPos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof TickingTileEntity) {
            TickingTileEntity ticking = (TickingTileEntity)blockEntity;
            ticking.tick();
        }
    }

    @Override
    @Nonnull
    public PartSlot getSlotFromState(Level world, BlockPos pos, BlockState newState) {
        return PartSlot.NONE;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        BlockEntity te;
        if (!world.f_46443_ && (te = world.m_7702_(pos)) instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onReplaced(world, pos, state, newstate);
        }
        super.m_6810_(state, world, pos, newstate, isMoving);
    }

    protected Property<?>[] getProperties() {
        return BaseBlock.getProperties(this.getRotationType());
    }

    public static Property<?>[] getProperties(RotationType rotationType) {
        return switch (rotationType) {
            default -> throw new IncompatibleClassChangeError();
            case RotationType.HORIZROTATION -> HORIZ_PROPERTIES;
            case RotationType.ROTATION -> ROTATING_PROPERTIES;
            case RotationType.NONE -> NONE_PROPERTIES;
        };
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        for (Property<?> property : this.getProperties()) {
            builder.m_61104_(new Property[]{property});
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Player placer = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockState state = super.m_5573_(context);
        return switch (this.getRotationType()) {
            default -> throw new IncompatibleClassChangeError();
            case RotationType.HORIZROTATION -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)placer.m_6350_().m_122424_());
            case RotationType.ROTATION -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)OrientationTools.getFacingFromEntity(pos, (Entity)placer));
            case RotationType.NONE -> state;
        };
    }

    protected Direction getOrientation(BlockPos pos, LivingEntity entity) {
        return switch (this.getRotationType()) {
            default -> throw new IncompatibleClassChangeError();
            case RotationType.HORIZROTATION -> OrientationTools.determineOrientationHoriz(entity);
            case RotationType.ROTATION -> OrientationTools.determineOrientation(pos, entity);
            case RotationType.NONE -> null;
        };
    }

    public Direction getFrontDirection(BlockState state) {
        return switch (this.getRotationType()) {
            default -> throw new IncompatibleClassChangeError();
            case RotationType.HORIZROTATION -> (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            case RotationType.ROTATION -> (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            case RotationType.NONE -> Direction.NORTH;
        };
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (this.getRotationType()) {
            default -> throw new IncompatibleClassChangeError();
            case RotationType.HORIZROTATION -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            case RotationType.ROTATION -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
            case RotationType.NONE -> state;
        };
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        state = this.m_6843_(state, rot);
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)tileEntity;
            genericTileEntity.rotateBlock(rot);
        }
        return state;
    }

    public Direction getRightDirection(BlockState state) {
        return this.getFrontDirection(state).m_122428_();
    }

    public Direction getLeftDirection(BlockState state) {
        return this.getFrontDirection(state).m_122427_();
    }

    public static Direction getFrontDirection(RotationType rotationType, BlockState state) {
        return switch (rotationType) {
            default -> throw new IncompatibleClassChangeError();
            case RotationType.HORIZROTATION -> OrientationTools.getOrientationHoriz(state);
            case RotationType.ROTATION -> OrientationTools.getOrientation(state);
            case RotationType.NONE -> Direction.SOUTH;
        };
    }

    @Override
    public TOPDriver getProbeDriver() {
        return this.topDriver;
    }

    @Override
    public List<ItemStack> getItemsForTab() {
        return Collections.emptyList();
    }
}

