/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class NetworkTools {
    public static FluidStack readFluidStack(ByteBuf dataIn) {
        FriendlyByteBuf buf = new FriendlyByteBuf(dataIn);
        CompoundTag nbt = buf.m_130260_();
        return FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
    }

    public static void writeFluidStack(ByteBuf dataOut, FluidStack fluidStack) {
        FriendlyByteBuf buf = new FriendlyByteBuf(dataOut);
        CompoundTag nbt = new CompoundTag();
        fluidStack.writeToNBT(nbt);
        try {
            buf.m_130079_(nbt);
        }
        catch (RuntimeException e) {
            Logging.logError("Error writing fluid stack", e);
        }
    }

    public static String readStringUTF8(FriendlyByteBuf dataIn) {
        if (!dataIn.readBoolean()) {
            return null;
        }
        return dataIn.m_130136_(Short.MAX_VALUE);
    }

    public static void writeStringUTF8(FriendlyByteBuf dataOut, String str) {
        if (str == null) {
            dataOut.writeBoolean(false);
            return;
        }
        dataOut.writeBoolean(true);
        dataOut.m_130070_(str);
    }

    public static void writeStringList(FriendlyByteBuf dataOut, @Nonnull List<String> list) {
        dataOut.writeInt(list.size());
        list.forEach(s -> NetworkTools.writeStringUTF8(dataOut, s));
    }

    @Nonnull
    public static List<String> readStringList(FriendlyByteBuf dataIn) {
        int size = dataIn.readInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(NetworkTools.readStringUTF8(dataIn));
        }
        return list;
    }

    public static ItemStack readItemStack(FriendlyByteBuf buf) {
        CompoundTag nbt = buf.m_130260_();
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt);
        stack.m_41764_(buf.readInt());
        return stack;
    }

    public static void writeItemStack(FriendlyByteBuf buf, ItemStack itemStack) {
        CompoundTag nbt = new CompoundTag();
        itemStack.m_41739_(nbt);
        try {
            buf.m_130079_(nbt);
            buf.writeInt(itemStack.m_41613_());
        }
        catch (Exception e) {
            Logging.logError("Error", e);
        }
    }

    public static <T extends Enum<T>> void writeEnum(ByteBuf buf, T value, T nullValue) {
        if (value == null) {
            buf.writeInt(nullValue.ordinal());
        } else {
            buf.writeInt(value.ordinal());
        }
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buf, T[] values) {
        return values[buf.readInt()];
    }

    public static <T extends Enum<T>> void writeEnumCollection(ByteBuf buf, Collection<T> collection) {
        buf.writeInt(collection.size());
        for (Enum type : collection) {
            buf.writeInt(type.ordinal());
        }
    }

    public static <T extends Enum<T>> void readEnumCollection(ByteBuf buf, Collection<T> collection, T[] values) {
        collection.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            collection.add(values[buf.readInt()]);
        }
    }

    @Nonnull
    public static List<ItemStack> readItemStackList(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            outputs.add(buf.m_130267_());
        }
        return outputs;
    }

    public static void writeItemStackList(FriendlyByteBuf buf, @Nonnull List<ItemStack> outputs) {
        buf.writeInt(outputs.size());
        for (ItemStack output : outputs) {
            buf.m_130055_(output);
        }
    }

    public static void writeBlockPosList(FriendlyByteBuf dataOut, @Nonnull List<BlockPos> list) {
        dataOut.writeInt(list.size());
        list.forEach(arg_0 -> ((FriendlyByteBuf)dataOut).m_130064_(arg_0));
    }

    @Nonnull
    public static List<BlockPos> readBlockPosList(FriendlyByteBuf dataIn) {
        int size = dataIn.readInt();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            list.add(dataIn.m_130135_());
        }
        return list;
    }
}

