/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mcjty.lib.api.container.IContainerDataListener;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.ValueHolder;
import mcjty.lib.typed.Key;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.DataSlot;

public class Sync {
    public static IContainerDataListener values(final ResourceLocation id, final GenericTileEntity te) {
        return new IContainerDataListener(){
            private Map<Key, Object> oldValues = new HashMap<Key, Object>();

            @Override
            public ResourceLocation getId() {
                return id;
            }

            private void copyToOld() {
                this.oldValues.clear();
                for (ValueHolder<?, ?> value : te.getValueMap().values()) {
                    Object v = value.getter().apply(te);
                    this.oldValues.put(value.key(), v);
                }
            }

            @Override
            public boolean isDirtyAndClear() {
                for (ValueHolder<?, ?> value : te.getValueMap().values()) {
                    Object v = value.getter().apply(te);
                    Key<?> key = value.key();
                    if (this.oldValues.containsKey(key) && Objects.equals(this.oldValues.get(key), v)) continue;
                    this.copyToOld();
                    return true;
                }
                return false;
            }

            @Override
            public void toBytes(FriendlyByteBuf buf) {
                for (ValueHolder<?, ?> value : te.getValueMap().values()) {
                    Object v = value.getter().apply(te);
                    value.key().type().serialize(buf, v);
                }
            }

            @Override
            public void readBuf(FriendlyByteBuf buf) {
                for (ValueHolder<?, ?> value : te.getValueMap().values()) {
                    value.key().type().deserialize(buf, value, te);
                }
            }
        };
    }

    public static IContainerDataListener string(final ResourceLocation id, final Supplier<String> getter, final Consumer<String> setter) {
        return new IContainerDataListener(){
            private String oldString = null;

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public boolean isDirtyAndClear() {
                String newValue = (String)getter.get();
                if (!Objects.equals(newValue, this.oldString)) {
                    this.oldString = newValue;
                    return true;
                }
                return false;
            }

            @Override
            public void toBytes(FriendlyByteBuf buf) {
                buf.m_130070_((String)getter.get());
            }

            @Override
            public void readBuf(FriendlyByteBuf buf) {
                setter.accept(buf.m_130136_(Short.MAX_VALUE));
            }
        };
    }

    public static IContainerDataListener flt(final ResourceLocation id, final Supplier<Float> getter, final Consumer<Float> setter) {
        return new IContainerDataListener(){
            private Float oldFloat = null;

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public boolean isDirtyAndClear() {
                Float newValue = (Float)getter.get();
                if (!Objects.equals(newValue, this.oldFloat)) {
                    this.oldFloat = newValue;
                    return true;
                }
                return false;
            }

            @Override
            public void toBytes(FriendlyByteBuf buf) {
                buf.writeFloat(((Float)getter.get()).floatValue());
            }

            @Override
            public void readBuf(FriendlyByteBuf buf) {
                setter.accept(Float.valueOf(buf.readFloat()));
            }
        };
    }

    public static DataSlot integer(final Supplier<Integer> getter, final Consumer<Integer> setter) {
        return new DataSlot(){

            public int m_6501_() {
                return (Integer)getter.get();
            }

            public void m_6422_(int v) {
                setter.accept(v);
            }
        };
    }

    public static DataSlot shortint(final Supplier<Short> getter, final Consumer<Short> setter) {
        return new DataSlot(){

            public int m_6501_() {
                return ((Short)getter.get()).shortValue();
            }

            public void m_6422_(int v) {
                setter.accept((short)v);
            }
        };
    }

    public static <T extends Enum<T>> DataSlot enumeration(final Supplier<T> getter, final Consumer<T> setter, T[] values) {
        return new DataSlot((Enum[])values){
            final /* synthetic */ Enum[] val$values;
            {
                this.val$values = enumArray;
            }

            public int m_6501_() {
                return ((Enum)getter.get()).ordinal();
            }

            public void m_6422_(int v) {
                setter.accept(this.val$values[v]);
            }
        };
    }

    public static DataSlot bool(final Supplier<Boolean> getter, final Consumer<Boolean> setter) {
        return new DataSlot(){

            public int m_6501_() {
                return (Boolean)getter.get() != false ? 1 : 0;
            }

            public void m_6422_(int v) {
                setter.accept(v != 0);
            }
        };
    }
}

