/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.effect;

import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class Wall_Watcher_Entity
extends Entity {
    static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.m_135353_(Wall_Watcher_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int effectiveChargeTime;
    double knockbackSpeedIndex;
    float damagePerEffectiveCharge;
    double dx;
    double dz;
    LivingEntity source;
    List<YUnchangedLivingEntity> watchedEntities;

    public Wall_Watcher_Entity(EntityType<? extends Wall_Watcher_Entity> entityTypeIn, Level level) {
        super(entityTypeIn, level);
    }

    public Wall_Watcher_Entity(Level level, BlockPos pos, int timer, int effectiveChargeTime, double knockbackSpeedIndex, float damagePerEffectiveCharge, double dx, double dz, LivingEntity source) {
        super((EntityType)ModEntities.WALL_WATCHER.get(), level);
        this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.f_19804_.m_135381_(TIMER, (Object)timer);
        this.effectiveChargeTime = effectiveChargeTime;
        this.knockbackSpeedIndex = knockbackSpeedIndex;
        this.damagePerEffectiveCharge = damagePerEffectiveCharge;
        this.dx = dx;
        this.dz = dz;
        this.source = source;
        this.watchedEntities = new ArrayList<YUnchangedLivingEntity>();
    }

    public void watch(LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.watchedEntities.add(new YUnchangedLivingEntity(livingEntity));
        }
    }

    public void removeFromWatchList(YUnchangedLivingEntity yUnchangedLivingEntity) {
        if (yUnchangedLivingEntity != null) {
            this.watchedEntities.remove(yUnchangedLivingEntity);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            int temp = (Integer)this.f_19804_.m_135370_(TIMER);
            if (this.watchedEntities != null && this.source != null) {
                if (!this.watchedEntities.isEmpty()) {
                    ArrayList<YUnchangedLivingEntity> entitiesRemoveFromWatchList = new ArrayList<YUnchangedLivingEntity>();
                    for (YUnchangedLivingEntity entity : this.watchedEntities) {
                        if (entity.livingEntity.f_19862_) {
                            if (!entity.livingEntity.m_7307_((Entity)this.source)) {
                                entity.livingEntity.f_19802_ = 0;
                                float realDamageApplied = this.damagePerEffectiveCharge * (float)this.effectiveChargeTime + 1.0f;
                                boolean flag = entity.livingEntity.m_6469_(this.m_269291_().m_269299_((Entity)this, this.source), realDamageApplied);
                                if (flag) {
                                    entity.livingEntity.m_5496_(SoundEvents.f_11913_, 0.3f, 1.0f);
                                    entity.livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), 50));
                                }
                            }
                            entitiesRemoveFromWatchList.add(entity);
                            continue;
                        }
                        entity.setMotion(this.dx * this.knockbackSpeedIndex, this.dz * this.knockbackSpeedIndex);
                    }
                    for (YUnchangedLivingEntity remove : entitiesRemoveFromWatchList) {
                        this.removeFromWatchList(remove);
                    }
                    if (temp - 1 == 0) {
                        this.watchedEntities.clear();
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                    } else {
                        this.f_19804_.m_135381_(TIMER, (Object)(temp - 1));
                    }
                } else if (temp - 1 == 0) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                } else {
                    this.f_19804_.m_135381_(TIMER, (Object)(temp - 1));
                }
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_7378_(CompoundTag p_20052_) {
        this.source = null;
    }

    protected void m_7380_(CompoundTag p_20139_) {
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TIMER, (Object)0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static class YUnchangedLivingEntity {
        LivingEntity livingEntity;
        double Y;

        public YUnchangedLivingEntity(LivingEntity livingEntity) {
            this.livingEntity = livingEntity;
            this.Y = livingEntity.m_20186_();
        }

        void setMotion(double X, double Z) {
            this.livingEntity.m_20334_(X, 0.0, Z);
            this.livingEntity.m_6034_(this.livingEntity.m_20185_(), this.Y, this.livingEntity.m_20189_());
            this.livingEntity.f_19864_ = true;
        }
    }
}

