/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.EntityInlineData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class InlineEntityRenderer
implements InlineRenderer<EntityInlineData> {
    public static final InlineEntityRenderer INSTANCE = new InlineEntityRenderer();

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("inline", "entity");
    }

    @Override
    public int render(EntityInlineData data, GuiGraphics context, int index, Style style, int codepoint, InlineRenderer.TextRenderingContext trContext) {
        Entity ent = data.getEntity((Level)Minecraft.m_91087_().f_91073_);
        if (ent == null) {
            return 0;
        }
        float width = ent.m_20205_();
        float height = ent.m_20206_();
        float rot = 15.0f;
        double radRot = Math.toRadians(rot % 90.0f);
        double pWidth = (double)width * (Math.cos(radRot) + Math.sin(radRot));
        int cDist = (int)Math.ceil(pWidth * 8.0 / (double)height) + 1;
        if (trContext.shadow()) {
            return cDist;
        }
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(ent);
        PoseStack matrices = context.m_280168_();
        matrices.m_85837_((double)cDist / 2.0, 8.0, 0.0);
        matrices.m_85841_(8.0f / height, -8.0f / height, 8.0f / height);
        Minecraft.m_91087_().m_91296_();
        Minecraft client = Minecraft.m_91087_();
        float tickDelta = client.m_91296_();
        matrices.m_252781_(Axis.f_252436_.m_252977_(rot));
        renderer.m_7392_(ent, 0.0f, 0.0f, matrices, (MultiBufferSource)context.m_280091_(), trContext.light());
        return cDist;
    }

    @Override
    public int charWidth(EntityInlineData data, Style style, int codepoint) {
        Entity ent = data.getEntity((Level)Minecraft.m_91087_().f_91073_);
        if (ent == null) {
            return 0;
        }
        float width = ent.m_20205_();
        float height = ent.m_20206_();
        float rot = 15.0f;
        double radRot = Math.toRadians(rot % 90.0f);
        double pWidth = (double)width * (Math.cos(radRot) + Math.sin(radRot));
        return (int)Math.ceil(pWidth * 8.0 / (double)height) + 1;
    }

    @Override
    public GlowHandling getGlowPreference(EntityInlineData forData) {
        return new GlowHandling.Full(forData.cradle.getId());
    }
}

