/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.mixin.core.MixinSetTessBuffer;
import com.samsthenerd.inline.utils.ColorUtils;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import com.samsthenerd.inline.utils.TextureSprite;
import com.samsthenerd.inline.utils.VCPImmediateButImLyingAboutIt;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.time.Duration;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Tuple;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;

public class InlineRenderCore {
    private static TextureTarget GLOW_BUFF = new TextureTarget(128, 128, true, Minecraft.f_91002_);
    private static final Cache<String, Spritelike> GLOW_TEXTURE_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(Duration.ofMinutes(5L)).removalListener(notif -> {
        Object patt6547$temp = notif.getValue();
        if (patt6547$temp instanceof TextureSprite) {
            TextureSprite tSprite = (TextureSprite)patt6547$temp;
            Minecraft.m_91087_().m_91097_().m_118513_(tSprite.getTextureId());
        }
    }).build();
    private static final Tesselator secondaryTess = new Tesselator();

    public static boolean textDrawerAcceptHandler(int index, Style style, int codepoint, RenderArgs args) {
        int rendererARGB;
        boolean needToHandleSize;
        MultiBufferSource.BufferSource imm;
        InlineData inlData = style.getInlineData();
        if (inlData == null) {
            return false;
        }
        InlineRenderer<?> renderer = InlineClientAPI.INSTANCE.getRenderer(inlData.getRendererId());
        if (renderer == null) {
            return false;
        }
        if (!(renderer.getGlowPreference(inlData) instanceof GlowHandling.None) && ((Boolean)style.getComponent(InlineStyle.GLOWY_MARKER_COMP)).booleanValue()) {
            return true;
        }
        int glowColor = (Integer)style.getComponent(InlineStyle.GLOWY_PARENT_COMP);
        boolean needsGlowChildren = glowColor != -1 && renderer.getGlowPreference(inlData) instanceof GlowHandling.Full;
        Tesselator heldTess = Tesselator.m_85913_();
        MixinSetTessBuffer.setInstance(secondaryTess);
        MultiBufferSource multiBufferSource = args.provider();
        MultiBufferSource.BufferSource immToUse = multiBufferSource instanceof MultiBufferSource.BufferSource ? (imm = (MultiBufferSource.BufferSource)multiBufferSource) : VCPImmediateButImLyingAboutIt.of(args.provider());
        immToUse.m_109911_();
        GuiGraphics drawContext = new GuiGraphics(Minecraft.m_91087_(), immToUse);
        PoseStack matrices = drawContext.m_280168_();
        matrices.m_85836_();
        double sizeMod = (Double)style.getComponent(InlineStyle.SIZE_MODIFIER_COMP);
        matrices.m_252931_(args.matrix());
        matrices.m_85850_().m_252943_().mul((Matrix3fc)new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f));
        matrices.m_252931_(new Matrix4f().scale(1.0f, 1.0f, 0.001f));
        matrices.m_252880_(args.x(), args.y(), 0.0f);
        double maxSizeMod = InlineClientAPI.INSTANCE.getConfig().maxChatSizeModifier();
        if (sizeMod > maxSizeMod && InlineRenderer.isFlat(matrices, args.layerType) && InlineRenderer.isChatty()) {
            sizeMod = maxSizeMod;
        }
        boolean bl = needToHandleSize = sizeMod != 1.0 && !renderer.handleOwnSizing(inlData);
        if (needToHandleSize) {
            double yOffset = (sizeMod - 1.0) * 4.0;
            matrices.m_85837_(0.0, -yOffset, 0.0);
            matrices.m_85841_((float)sizeMod, (float)sizeMod, 1.0f);
        }
        float alphaToUse = args.alpha() == 0.0f ? 1.0f : args.alpha();
        int usableColor = rendererARGB = FastColor.ARGB32.m_13660_((int)Math.round(alphaToUse * 255.0f), (int)Math.round(args.red() * 255.0f), (int)Math.round(args.green() * 255.0f), (int)Math.round(args.blue() * 255.0f));
        if (style.m_131135_() != null) {
            usableColor = FastColor.ARGB32.m_13657_((int)rendererARGB, (int)(style.m_131135_().m_131265_() | 0xFF000000));
        }
        InlineRenderer.TextRenderingContext trContext = new InlineRenderer.TextRenderingContext(args.light(), args.shadow(), args.brightnessMultiplier(), args.red(), args.green(), args.blue(), args.alpha() == 0.0f ? 1.0f : args.alpha(), args.layerType(), args.provider(), (Boolean)style.getComponent(InlineStyle.GLOWY_MARKER_COMP), (Integer)style.getComponent(InlineStyle.GLOWY_PARENT_COMP), usableColor);
        if (!renderer.handleOwnTransparency(inlData)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaToUse);
        }
        if (needsGlowChildren) {
            Tuple<Spritelike, Runnable> texResult = InlineRenderCore.getGlowTextureSprite(inlData, renderer, immToUse, sizeMod, index, style, codepoint, trContext);
            Spritelike backSprite = (Spritelike)texResult.m_14418_();
            int brighterGlow = ColorUtils.ARGBtoHSB(glowColor)[2] > ColorUtils.ARGBtoHSB(usableColor)[2] ? glowColor : usableColor;
            SpritelikeRenderers.getRenderer(backSprite).drawSpriteWithLight(backSprite, drawContext, -2.0f, -4.0f, 0.0f, 16.0f, 16.0f, trContext.light(), brighterGlow);
            ((Runnable)texResult.m_14419_()).run();
        }
        matrices.m_252880_(0.0f, 0.0f, 10.0f);
        args.xUpdater().addAndGet((double)((float)renderer.render(inlData, drawContext, index, style, codepoint, trContext) * (needToHandleSize ? (float)sizeMod : 1.0f)));
        immToUse.m_109911_();
        if (!renderer.handleOwnTransparency(inlData)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrices.m_85849_();
        MixinSetTessBuffer.setInstance(heldTess);
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Tuple<Spritelike, Runnable> getGlowTextureSprite(InlineData inlData, InlineRenderer renderer, MultiBufferSource.BufferSource immToUse, double sizeMod, int index, Style style, int codepoint, InlineRenderer.TextRenderingContext trContext) {
        Spritelike texSpriteMaybe;
        double outlineScaleBack = 1.0 / sizeMod;
        boolean needToHandleSize = sizeMod != 1.0 && !renderer.handleOwnSizing(inlData);
        GlowHandling glowHandling = renderer.getGlowPreference(inlData);
        if (!(glowHandling instanceof GlowHandling.Full)) {
            return null;
        }
        GlowHandling.Full fullHandling = (GlowHandling.Full)glowHandling;
        String texCacheId = null;
        if (fullHandling.cacheId != null && (texSpriteMaybe = (Spritelike)GLOW_TEXTURE_CACHE.getIfPresent((Object)(texCacheId = "inlineglowtexture" + renderer.getId().m_214298_() + "." + fullHandling.cacheId + sizeMod))) != null) {
            return new Tuple((Object)texSpriteMaybe, () -> {});
        }
        int resScale = 8;
        GLOW_BUFF.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        GLOW_BUFF.m_83954_(false);
        Minecraft.m_91087_().m_91385_().m_83970_();
        PoseStack mvStack = RenderSystem.getModelViewStack();
        Matrix4f backupProjMatrix = RenderSystem.getProjectionMatrix();
        mvStack.m_85836_();
        mvStack.m_166856_();
        RenderSystem.applyModelViewMatrix();
        VertexSorting backupVertexSorter = RenderSystem.getVertexSorting();
        RenderSystem.backupProjectionMatrix();
        Matrix4f newProjMatrix = new Matrix4f();
        newProjMatrix.identity();
        newProjMatrix.setOrtho(0.0f, (float)(16 * resScale), 0.0f, (float)(16 * resScale), 0.0f, 100.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)newProjMatrix, (VertexSorting)VertexSorting.f_276450_);
        GLOW_BUFF.m_83947_(true);
        GuiGraphics glowContext = new GuiGraphics(Minecraft.m_91087_(), immToUse);
        PoseStack glowStack = glowContext.m_280168_();
        glowStack.m_85836_();
        glowStack.m_252880_((float)(2 * resScale), (float)(4 * resScale), -50.0f);
        glowStack.m_85841_((float)resScale, (float)resScale, 1.0f);
        glowStack.m_252931_(new Matrix4f().scale(1.0f, 1.0f, 0.01f));
        float xOffsetDiff = (float)renderer.render(inlData, glowContext, index, style, codepoint, trContext) * (needToHandleSize ? (float)sizeMod : 1.0f);
        immToUse.m_109911_();
        mvStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)backupProjMatrix, (VertexSorting)backupVertexSorter);
        GLOW_BUFF.m_83970_();
        try (NativeImage nativeImage = new NativeImage(16 * resScale, 16 * resScale, true);){
            GLOW_BUFF.m_83956_();
            nativeImage.m_85045_(0, false);
            GLOW_BUFF.m_83963_();
            NativeImage fullImage = new NativeImage(nativeImage.m_84982_(), nativeImage.m_85084_(), true);
            int outlineRange = (int)Math.round((double)resScale * outlineScaleBack);
            LinkedList<Integer> pixelQueue = new LinkedList<Integer>();
            Int2IntOpenHashMap seenPixels = new Int2IntOpenHashMap();
            int imgWidth = nativeImage.m_84982_();
            int imgHeight = nativeImage.m_85084_();
            for (int px = 0; px < imgWidth; ++px) {
                for (int py = 0; py < imgHeight; ++py) {
                    if (FastColor.ARGB32.m_13655_((int)nativeImage.m_84985_(px, py)) == 0) continue;
                    int thisPos = px + py * imgWidth;
                    seenPixels.put(thisPos, 0);
                    pixelQueue.add(thisPos);
                }
            }
            nativeImage.close();
            while (!pixelQueue.isEmpty()) {
                int cPix = (Integer)pixelQueue.poll();
                int cX = cPix % imgWidth;
                int cY = cPix / imgWidth;
                fullImage.m_84988_(cX, cY, -1);
                if (seenPixels.get(cPix) >= outlineRange) continue;
                for (int i = -1; i <= 1; ++i) {
                    if (cX + i < 0 || cX + i >= imgWidth) continue;
                    for (int j = -1; j <= 1; ++j) {
                        int nbrPos;
                        if (cY + j < 0 || cY + j >= imgHeight || seenPixels.containsKey(nbrPos = cPix + i + j * imgWidth)) continue;
                        seenPixels.put(nbrPos, seenPixels.get(cPix) + 1);
                        pixelQueue.add(nbrPos);
                    }
                }
            }
            Minecraft.m_91087_().m_91385_().m_83947_(true);
            if (texCacheId != null) {
                ResourceLocation backTexId = Minecraft.m_91087_().m_91097_().m_118490_(texCacheId, new DynamicTexture(fullImage));
                TextureSprite tSprite = new TextureSprite(backTexId);
                GLOW_TEXTURE_CACHE.put((Object)texCacheId, (Object)tSprite);
                Tuple tuple = new Tuple((Object)tSprite, () -> {});
                return tuple;
            }
            ResourceLocation backTexId = Minecraft.m_91087_().m_91097_().m_118490_(new ResourceLocation("inline", "glowtextureback").m_214298_(), new DynamicTexture(fullImage));
            Tuple tuple = new Tuple((Object)new TextureSprite(backTexId), () -> Minecraft.m_91087_().m_91097_().m_118513_(backTexId));
            return tuple;
        }
        catch (Exception e) {
            Inline.LOGGER.error(e.toString());
            return null;
        }
    }

    public record RenderArgs(float x, float y, Matrix4f matrix, int light, boolean shadow, float brightnessMultiplier, float red, float green, float blue, float alpha, Font.DisplayMode layerType, MultiBufferSource provider, AtomicDouble xUpdater) {
    }
}

