/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.URLTextureUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public class URLSprite
extends Spritelike {
    private String url;
    private ResourceLocation id;
    private ResourceLocation textureID;
    private float minU;
    private float minV;
    private float maxU;
    private float maxV;

    public URLSprite(String url, ResourceLocation id, float minU, float minV, float maxU, float maxV) {
        this.url = url;
        this.id = id;
        this.minU = minU;
        this.minV = minV;
        this.maxU = maxU;
        this.maxV = maxV;
    }

    public URLSprite(String url, ResourceLocation id) {
        this(url, id, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    public Spritelike.SpritelikeType getType() {
        return UrlSpriteType.INSTANCE;
    }

    @Override
    public ResourceLocation getTextureId() {
        return URLTextureUtils.loadTextureFromURL(this.url, this.id);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public float getMinU() {
        return this.minU;
    }

    @Override
    public float getMinV() {
        return this.minV;
    }

    @Override
    public float getMaxU() {
        return this.maxU;
    }

    @Override
    public float getMaxV() {
        return this.maxV;
    }

    @Override
    public int getTextureWidth() {
        this.getTextureId();
        Tuple<Integer, Integer> dims = URLTextureUtils.getTextureDimensions(this.id);
        if (dims == null) {
            return 0;
        }
        return (Integer)dims.m_14418_();
    }

    @Override
    public int getTextureHeight() {
        this.getTextureId();
        Tuple<Integer, Integer> dims = URLTextureUtils.getTextureDimensions(this.id);
        if (dims == null) {
            return 0;
        }
        return (Integer)dims.m_14419_();
    }

    public static class UrlSpriteType
    implements Spritelike.SpritelikeType {
        public static final UrlSpriteType INSTANCE = new UrlSpriteType();
        private static final Codec<URLSprite> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("url").forGetter(URLSprite::getUrl), (App)ResourceLocation.f_135803_.fieldOf("id").forGetter(URLSprite::getId), (App)Codec.FLOAT.optionalFieldOf("minU", (Object)Float.valueOf(0.0f)).forGetter(URLSprite::getMinU), (App)Codec.FLOAT.optionalFieldOf("minV", (Object)Float.valueOf(0.0f)).forGetter(URLSprite::getMinV), (App)Codec.FLOAT.optionalFieldOf("maxU", (Object)Float.valueOf(1.0f)).forGetter(URLSprite::getMaxU), (App)Codec.FLOAT.optionalFieldOf("maxV", (Object)Float.valueOf(1.0f)).forGetter(URLSprite::getMaxV)).apply((Applicative)instance, URLSprite::new));

        public Codec<URLSprite> getCodec() {
            return CODEC;
        }

        @Override
        public String getId() {
            return "url";
        }
    }
}

