/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.samsthenerd.inline.Inline;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public class URLTextureUtils {
    private static final Map<ResourceLocation, ResourceLocation> LOADED_TEXTURES = Collections.synchronizedMap(new HashMap());
    private static final Map<ResourceLocation, Tuple<Integer, Integer>> TEXTURE_DIMENSIONS = Collections.synchronizedMap(new HashMap());

    public static ResourceLocation loadTextureFromURL(String url, ResourceLocation textureId) {
        ResourceLocation maybeTexture = LOADED_TEXTURES.get(textureId);
        if (maybeTexture != null) {
            return maybeTexture;
        }
        CompletableFuture.runAsync(() -> {
            try {
                URL textureUrl = new URL(url);
                InputStream stream = textureUrl.openStream();
                try {
                    NativeImage baseImage = NativeImage.m_85058_((InputStream)stream);
                    if (baseImage == null) {
                        return;
                    }
                    DynamicTexture texture = new DynamicTexture(baseImage);
                    Runnable registerTextureRunnable = () -> {
                        ResourceLocation actualTextureId = Minecraft.m_91087_().m_91097_().m_118490_(textureId.m_214298_(), texture);
                        LOADED_TEXTURES.put(textureId, actualTextureId);
                        TEXTURE_DIMENSIONS.put(textureId, (Tuple<Integer, Integer>)new Tuple((Object)baseImage.m_84982_(), (Object)baseImage.m_85084_()));
                    };
                    Minecraft.m_91087_().execute(() -> {
                        Objects.requireNonNull(registerTextureRunnable);
                        RenderSystem.recordRenderCall(registerTextureRunnable::run);
                    });
                }
                catch (Exception e) {
                    Inline.LOGGER.error("Failed to load texture from URL: " + url + "\n:" + e);
                }
            }
            catch (Exception e) {
                Inline.LOGGER.error("Failed to load texture from URL: " + url + "\n:" + e);
            }
        });
        return new ResourceLocation("");
    }

    @Nullable
    public static Tuple<Integer, Integer> getTextureDimensions(ResourceLocation textureId) {
        return TEXTURE_DIMENSIONS.get(textureId);
    }
}

