/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils.cradles;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.samsthenerd.inline.utils.EntityCradle;
import com.samsthenerd.inline.utils.FakeClientPlayerMaker;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class PlayerCradle
extends EntityCradle {
    private static final HashMap<UUID, Entity> UUID_PLAYER_CACHE = new HashMap();
    private static final HashMap<String, Entity> NAME_PLAYER_CACHE = new HashMap();
    public static final Codec<GameProfile> GAME_PROFILE_CODEC = Codec.either((Codec)Codec.STRING.fieldOf("username").codec(), (Codec)UUIDUtil.f_252480_.fieldOf("uuid").codec()).xmap(nameOrId -> (GameProfile)nameOrId.map(name -> new GameProfile(null, name), uuid -> new GameProfile(uuid, null)), profile -> {
        String name = profile.getName();
        if (name != null && !name.isEmpty()) {
            return Either.left((Object)name);
        }
        return Either.right((Object)profile.getId());
    });
    private GameProfile profile;

    public PlayerCradle(GameProfile profile) {
        this.profile = profile;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    @Override
    public EntityCradle.CradleType<?> getType() {
        return PlayerCradleType.INSTANCE;
    }

    @Override
    public String getId() {
        return this.profile.getId() == null ? this.profile.getName() : this.profile.getId().toString();
    }

    @Override
    public Entity getEntity(Level world) {
        UUID playerId = this.profile.getId();
        if (playerId != null && UUID_PLAYER_CACHE.containsKey(playerId)) {
            return UUID_PLAYER_CACHE.get(playerId);
        }
        String playerName = this.profile.getName();
        if (playerName != null && !playerName.equals("") && NAME_PLAYER_CACHE.containsKey(playerName)) {
            return NAME_PLAYER_CACHE.get(playerName);
        }
        if (!world.m_5776_()) {
            return null;
        }
        Tuple<Entity, Boolean> playerRes = FakeClientPlayerMaker.getPlayerEntity(this.profile);
        if (((Boolean)playerRes.m_14419_()).booleanValue() && playerId != null) {
            UUID_PLAYER_CACHE.put(playerId, (Entity)playerRes.m_14418_());
        }
        if (((Boolean)playerRes.m_14419_()).booleanValue() && playerName != null && !playerName.equals("")) {
            NAME_PLAYER_CACHE.put(playerName, (Entity)playerRes.m_14418_());
        }
        return (Entity)playerRes.m_14418_();
    }

    private static class PlayerCradleType
    implements EntityCradle.CradleType<PlayerCradle> {
        public static PlayerCradleType INSTANCE = EntityCradle.addCradleType(new PlayerCradleType());

        private PlayerCradleType() {
        }

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("inline", "nbt");
        }

        @Override
        public Codec<PlayerCradle> getCodec() {
            return GAME_PROFILE_CODEC.xmap(PlayerCradle::new, PlayerCradle::getProfile);
        }
    }
}

