/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.mixin;

import com.leclowndu93150.particlerain.ClientStuff;
import com.leclowndu93150.particlerain.ParticleRainClient;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntUnaryOperator;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpriteLoader.class})
public abstract class SpriteLoaderMixin {
    @Shadow
    @Final
    private int f_276068_;
    @Shadow
    @Final
    private int f_276071_;
    @Shadow
    @Final
    private ResourceLocation f_244500_;
    @Shadow
    @Final
    private int f_243676_;
    @Unique
    private List<SpriteContents> spriteContentsList;

    @Inject(method={"stitch"}, at={@At(value="HEAD")})
    public void stitch(List<SpriteContents> list, int i, Executor executor, CallbackInfoReturnable<SpriteLoader.Preparations> cir) {
        this.spriteContentsList = list;
    }

    @Inject(method={"stitch"}, at={@At(value="NEW", target="net/minecraft/client/renderer/texture/Stitcher", ordinal=0)}, cancellable=true)
    private void registerWeatherParticles(List<SpriteContents> list, int i, Executor executor, CallbackInfoReturnable<SpriteLoader.Preparations> cir) {
        Stitcher stitcher = new Stitcher(this.f_243676_, this.f_243676_, i);
        System.out.println("Registering weather particles before the if statement");
        if (this.f_244500_.equals((Object)ResourceLocation.m_135820_((String)"textures/atlas/particles.png"))) {
            int j;
            int j2;
            System.out.println("Registering weather particles");
            ParticleRainClient.particleCount = 0;
            ParticleRainClient.fogCount = 0;
            NativeImage rainImage = null;
            NativeImage snowImage = null;
            try {
                rainImage = ClientStuff.loadTexture(new ResourceLocation("minecraft", "textures/environment/rain.png"));
                snowImage = ClientStuff.loadTexture(new ResourceLocation("minecraft", "textures/environment/snow.png"));
                if (ParticleRainClient.config.biomeTint) {
                    rainImage.m_284481_((IntUnaryOperator)ClientStuff.desaturateOperation);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (j2 = 0; j2 < 4; ++j2) {
                stitcher.m_246099_((Stitcher.Entry)ClientStuff.splitImage(rainImage, j2, "rain"));
            }
            for (j2 = 0; j2 < 4; ++j2) {
                stitcher.m_246099_((Stitcher.Entry)ClientStuff.splitImage(snowImage, j2, "snow"));
            }
            int rippleResolution = ClientStuff.getRippleResolution(this.spriteContentsList);
            for (j = 0; j < 8; ++j) {
                stitcher.m_246099_((Stitcher.Entry)ClientStuff.generateRipple(j, rippleResolution));
            }
            if (ParticleRainClient.config.biomeTint) {
                for (j = 0; j < 4; ++j) {
                    NativeImage splashImage = null;
                    try {
                        splashImage = ClientStuff.loadTexture(new ResourceLocation("textures/particle/splash_" + j + ".png"));
                        splashImage.m_284481_((IntUnaryOperator)ClientStuff.desaturateOperation);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    stitcher.m_246099_((Stitcher.Entry)new SpriteContents(new ResourceLocation("particlerain", "splash" + j), new FrameSize(splashImage.m_84982_(), splashImage.m_85084_()), splashImage, AnimationMetadataSection.f_119012_));
                }
            }
        }
        for (SpriteContents contents : list) {
            stitcher.m_246099_((Stitcher.Entry)contents);
        }
        try {
            stitcher.m_118193_();
        }
        catch (StitcherException var16) {
            throw new ReportedException(CrashReport.m_127521_((Throwable)var16, (String)"Stitching"));
        }
        int width = Math.max(stitcher.m_118174_(), this.f_276071_);
        int height = Math.max(stitcher.m_118187_(), this.f_276068_);
        Map<ResourceLocation, TextureAtlasSprite> regions = this.m_276091_((Stitcher<SpriteContents>)stitcher, width, height);
        TextureAtlasSprite missingSprite = regions.get(MissingTextureAtlasSprite.m_118071_());
        CompletableFuture<Object> future = i > 0 ? CompletableFuture.runAsync(() -> regions.values().forEach(sprite -> sprite.m_245424_().m_246368_(i)), executor) : CompletableFuture.completedFuture(null);
        cir.setReturnValue((Object)new SpriteLoader.Preparations(width, height, i, missingSprite, regions, future));
    }

    @Shadow
    protected abstract Map<ResourceLocation, TextureAtlasSprite> m_276091_(Stitcher<SpriteContents> var1, int var2, int var3);
}

