/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ClientStuff;
import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRegistry;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RainParticle
extends WeatherParticle {
    protected RainParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        if (ParticleRainClient.config.biomeTint) {
            ClientStuff.applyWaterTint(this, level, (BlockPos)this.pos);
        }
        this.f_107663_ = ParticleRainClient.config.rain.size;
        this.f_107226_ = ParticleRainClient.config.rain.gravity;
        this.f_107216_ = -this.f_107226_;
        this.m_108337_(Minecraft.m_91087_().f_91061_.f_107296_.m_118316_(new ResourceLocation("particlerain", "rain" + this.f_107223_.m_188503_(4))));
        this.f_107215_ = level.m_46470_() ? (double)(this.f_107226_ * ParticleRainClient.config.rain.stormWindStrength) : (double)(this.f_107226_ * ParticleRainClient.config.rain.windStrength);
        if (ParticleRainClient.config.yLevelWindAdjustment) {
            this.f_107215_ *= ClientStuff.yLevelWindAdjustment(y);
        }
        this.f_107217_ = this.f_107215_;
        this.f_107225_ = ParticleRainClient.config.particleRadius * 5;
        Vec3 vec3 = Minecraft.m_91087_().f_91075_.m_20182_();
        this.f_107231_ = (float)(org.joml.Math.atan2((double)(x - vec3.f_82479_), (double)(z - vec3.f_82481_)) + 1.5707963705062866);
    }

    @Override
    public void m_5989_() {
        Vec3 raycastEnd;
        Vec3 raycastStart;
        BlockHitResult hit;
        super.m_5989_();
        if (this.f_107224_ < 10) {
            this.f_107230_ = org.joml.Math.clamp((float)0.0f, (float)((float)ParticleRainClient.config.rain.opacity / 100.0f), (float)this.f_107230_);
        }
        if (this.f_107218_ || !this.f_107208_.m_6425_((BlockPos)this.pos).m_76178_()) {
            if ((ParticleRainClient.config.doSplashParticles || ParticleRainClient.config.doSmokeParticles || ParticleRainClient.config.doRippleParticles) && Minecraft.m_91087_().f_91075_.m_20182_().m_82554_(this.pos.m_252807_()) < (double)ParticleRainClient.config.particleRadius - (double)ParticleRainClient.config.particleRadius / 2.0) {
                for (int i = 0; i < ParticleRainClient.config.rain.splashDensity; ++i) {
                    Vec3 spawnPos = Vec3.m_272021_((Vec3i)this.pos, (double)(this.f_107223_.m_188501_() * 3.0f - 1.0f), (double)0.0, (double)(this.f_107223_.m_188501_() * 3.0f - 1.0f));
                    double d = this.f_107223_.m_188500_();
                    double e = this.f_107223_.m_188500_();
                    BlockPos blockPos = BlockPos.m_274446_((Position)spawnPos);
                    BlockState blockState = this.f_107208_.m_8055_(blockPos);
                    FluidState fluidState = this.f_107208_.m_6425_(blockPos);
                    VoxelShape voxelShape = blockState.m_60812_((BlockGetter)this.f_107208_, blockPos);
                    double voxelHeight = voxelShape.m_83290_(Direction.Axis.Y, d, e);
                    double fluidHeight = fluidState.m_76155_((BlockGetter)this.f_107208_, blockPos);
                    double height = Math.max(voxelHeight, fluidHeight);
                    Vec3 raycastStart2 = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
                    Vec3 raycastEnd2 = new Vec3(spawnPos.f_82479_, this.f_107213_, spawnPos.f_82481_);
                    BlockHitResult hit2 = this.f_107208_.m_45547_(new ClipContext(raycastStart2, raycastEnd2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)Minecraft.m_91087_().f_91074_));
                    Vec2 raycastHit = new Vec2((float)hit2.m_82450_().f_82479_, (float)hit2.m_82450_().f_82481_);
                    if (height == 0.0) continue;
                    Vec2 vec2 = new Vec2((float)spawnPos.f_82479_, (float)spawnPos.f_82481_);
                    if (!((double)raycastHit.m_165914_(vec2) < 0.01)) continue;
                    if (ParticleRainClient.config.doRippleParticles && fluidState.m_164512_((Fluid)Fluids.f_76193_)) {
                        if (height == 1.0) continue;
                        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleRegistry.RIPPLE.get(), spawnPos.f_82479_, spawnPos.f_82480_ + height, spawnPos.f_82481_, 0.0, 0.0, 0.0);
                        if (!this.f_107208_.m_46470_() || !ParticleRainClient.config.doSplashParticles) continue;
                        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123761_, spawnPos.f_82479_, spawnPos.f_82480_ + height, spawnPos.f_82481_, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (ParticleRainClient.config.doSmokeParticles && (blockState.m_204336_(BlockTags.f_13058_) || blockState.m_204336_(BlockTags.f_13086_))) {
                        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123762_, spawnPos.f_82479_, spawnPos.f_82480_ + height, spawnPos.f_82481_, 0.0, 0.0, 0.0);
                        if (!this.f_107208_.m_46470_()) continue;
                        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123755_, spawnPos.f_82479_, spawnPos.f_82480_ + height, spawnPos.f_82481_, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (!ParticleRainClient.config.doSplashParticles) continue;
                    Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123761_, spawnPos.f_82479_, spawnPos.f_82480_ + height, spawnPos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
            this.m_107274_();
        } else if (this.removeIfObstructed() && (hit = this.f_107208_.m_45547_(new ClipContext(raycastStart = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_), raycastEnd = new Vec3(this.f_107212_ + (double)ParticleRainClient.config.rain.windStrength, this.f_107213_, this.f_107214_ + (double)ParticleRainClient.config.rain.windStrength), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)Minecraft.m_91087_().f_91074_))).m_6662_().equals((Object)HitResult.Type.BLOCK)) {
            BlockState state;
            if (ParticleRainClient.config.doStreakParticles && Minecraft.m_91087_().f_91075_.m_20182_().m_82554_(this.pos.m_252807_()) < (double)ParticleRainClient.config.particleRadius - (double)ParticleRainClient.config.particleRadius / 2.0 && ((state = this.f_107208_.m_8055_(hit.m_82425_())).m_204336_(BlockTags.f_13049_) || state.m_204336_(BlockTags.f_144282_))) {
                Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleRegistry.STREAK.get(), this.f_107212_, this.f_107213_, this.f_107214_, (double)hit.m_82434_().m_122416_(), 0.0, 0.0);
                Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123761_, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickPercentage) {
        Vector3f camPos = camera.m_90583_().m_252839_();
        float x = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107209_, (double)this.f_107212_) - (double)camPos.x);
        float y = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107210_, (double)this.f_107213_) - (double)camPos.y);
        float z = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107211_, (double)this.f_107214_) - (double)camPos.z);
        Vector3f delta = new Vector3f((float)this.f_107215_, (float)this.f_107216_, (float)this.f_107217_);
        float angle = org.joml.Math.acos((float)delta.normalize().y);
        Vector3f axis = new Vector3f(-delta.z(), 0.0f, delta.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        quaternion.mul((Quaternionfc)Axis.f_252392_.m_252961_(this.f_107231_));
        quaternion = this.flipItTurnwaysIfBackfaced(quaternion, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, tickPercentage);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new RainParticle(level, x, y, z);
        }
    }
}

