/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;

public class ColourMultiplier
implements IVertexOperation {
    private static final ThreadLocal<ColourMultiplier> instances = ThreadLocal.withInitial(() -> new ColourMultiplier(-1));
    public static final int operationIndex = IVertexOperation.registerOperation();
    public int colour;

    public static ColourMultiplier instance(int colour) {
        ColourMultiplier instance = instances.get();
        instance.colour = colour;
        return instance;
    }

    public ColourMultiplier(int colour) {
        this.colour = colour;
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        if (this.colour == -1) {
            return false;
        }
        ccrs.pipeline.addDependency(ccrs.colourAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        ccrs.colour = ColourRGBA.multiply(ccrs.colour, this.colour);
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

