/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.stacks.AEKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.core.AppEng;
import appeng.menu.AEBaseMenu;
import appeng.menu.slot.FakeSlot;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.client.Hotkeys;
import net.pedroksl.advanced_ae.gui.patternencoder.AdvPatternEncoderMenu;
import net.pedroksl.advanced_ae.gui.patternencoder.DirectionInputButton;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.AdvPatternEncoderChangeDirectionPacket;

public class AdvPatternEncoderScreen
extends AEBaseScreen<AdvPatternEncoderMenu> {
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final int VISIBLE_ROWS = 4;
    private static final int LIST_ANCHOR_X = 20;
    private static final int LIST_ANCHOR_Y = 35;
    private static final int DIRECTION_BUTTONS_OFFSET_X = 2;
    private static final int DIRECTION_BUTTONS_WIDTH = 13;
    private static final int DIRECTION_BUTTONS_HEIGHT = 15;
    private static final Rect2i SLOT_BBOX = new Rect2i(7, 121, 18, 18);
    private static final Rect2i HIGHLIGHT_BBOX = new Rect2i(0, 0, 15, 17);
    private final ResourceLocation DEFAULT_TEXTURE = AppEng.makeId((String)"textures/guis/adv_pattern_encoder.png");
    private final ResourceLocation HIGHLIGHT_TEXTURE = AdvancedAE.makeId("textures/guis/selection_ring.png");
    private final Scrollbar scrollbar;
    private HashMap<AEKey, Direction> inputList = new HashMap();
    private final HashMap<AEKey, DirectionInputButton[]> directionButtons = new HashMap();
    private final ArrayList<InputRow> rows = new ArrayList();

    public AdvPatternEncoderScreen(AdvPatternEncoderMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.SMALL);
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int currentRow;
        ((AdvPatternEncoderMenu)this.f_97732_).f_38839_.removeIf(slot -> slot instanceof FakeSlot);
        this.directionButtons.forEach((key, value) -> {
            for (int x = 0; x < 7; ++x) {
                value[x].f_93624_ = false;
            }
        });
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int visibleRows = Math.min(4, this.inputList.size());
        for (int i = 0; i < visibleRows && (currentRow = scrollLevel + i) < this.inputList.size(); ++i) {
            InputRow row = this.rows.get(currentRow);
            SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
            renderContext.renderItem(row.key().wrapForDisplayOrFilter(), 21, 36 + i * 18, 16.0f, 16.0f);
            DirectionInputButton[] buttons = this.directionButtons.get(row.key);
            int highlight = this.getSelectedDirButton(row.dir);
            for (int col = 0; col < 7; ++col) {
                DirectionInputButton button = buttons[col];
                button.m_264152_(this.f_97735_ + 20 + 1 + 18 + (col + 1) * 2 + col * 13, this.f_97736_ + 35 + 1 + i * 18);
                button.setHighlighted(col == highlight);
                button.f_93624_ = true;
            }
        }
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        int currentX = offsetX + 20;
        int currentY = offsetY + 35;
        int visibleRows = Math.min(4, this.inputList.size());
        for (int i = 0; i < visibleRows; ++i) {
            guiGraphics.m_280218_(this.DEFAULT_TEXTURE, currentX, currentY, SLOT_BBOX.m_110085_(), SLOT_BBOX.m_110086_(), SLOT_BBOX.m_110090_(), SLOT_BBOX.m_110091_());
            currentY += 18;
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.refreshList();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.isCloseHotkey(keyCode, scanCode)) {
            this.getPlayer().m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private boolean isCloseHotkey(int keyCode, int scanCode) {
        Hotkeys.AAEHotkey hotkey;
        String hotkeyId = ((AdvPatternEncoderMenu)this.m_6262_()).getHost().getCloseHotkey();
        if (hotkeyId != null && (hotkey = Hotkeys.getHotkeyMapping(hotkeyId)) != null) {
            return hotkey.mapping().m_90832_(keyCode, scanCode);
        }
        return false;
    }

    public void update(HashMap<AEKey, Direction> inputList) {
        this.inputList.clear();
        this.directionButtons.forEach((k, v) -> {
            for (DirectionInputButton btn : v) {
                this.m_169411_((GuiEventListener)btn);
            }
        });
        this.directionButtons.clear();
        this.rows.clear();
        this.inputList = inputList;
        this.refreshList();
    }

    private void refreshList() {
        for (AEKey key : this.inputList.keySet()) {
            this.rows.add(new InputRow(key, this.inputList.get(key)));
            DirectionInputButton[] buttons = new DirectionInputButton[7];
            for (int x = 0; x < 7; ++x) {
                DirectionInputButton button = new DirectionInputButton(0, 0, 13, 15, this.getDirButtonTexture(x), this::directionButtonPressed);
                button.setHighlight(this.HIGHLIGHT_TEXTURE, 0, 0, HIGHLIGHT_BBOX.m_110090_(), HIGHLIGHT_BBOX.m_110091_(), 32, 32);
                button.setKey(key);
                button.setIndex(x);
                button.f_93624_ = false;
                buttons[x] = (DirectionInputButton)this.m_142416_((GuiEventListener)button);
            }
            this.directionButtons.put(key, buttons);
        }
        this.resetScrollbar();
    }

    private void directionButtonPressed(Button b) {
        DirectionInputButton button = (DirectionInputButton)b;
        AAENetworkHandler.INSTANCE.sendToServer(new AdvPatternEncoderChangeDirectionPacket(button.getKey(), button.getDirection()));
    }

    private int getSelectedDirButton(@Nullable Direction dir) {
        if (dir == null) {
            return 0;
        }
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> 1;
            case Direction.EAST -> 2;
            case Direction.SOUTH -> 3;
            case Direction.WEST -> 4;
            case Direction.UP -> 5;
            case Direction.DOWN -> 6;
        };
    }

    private ResourceLocation getDirButtonTexture(int index) {
        return switch (index) {
            case 1 -> AdvancedAE.makeId("textures/guis/north_button.png");
            case 2 -> AdvancedAE.makeId("textures/guis/east_button.png");
            case 3 -> AdvancedAE.makeId("textures/guis/south_button.png");
            case 4 -> AdvancedAE.makeId("textures/guis/west_button.png");
            case 5 -> AdvancedAE.makeId("textures/guis/up_button.png");
            case 6 -> AdvancedAE.makeId("textures/guis/down_button.png");
            default -> AdvancedAE.makeId("textures/guis/any_button.png");
        };
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(72);
        this.scrollbar.setRange(0, this.inputList.size() - 4, 2);
    }

    public record InputRow(AEKey key, @Nullable Direction dir) {
    }
}

