/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.config.CopyMode;
import appeng.api.config.Settings;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.util.ConfigInventory;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;

public class PortableCellWorkbenchMenuHost
extends ItemMenuHost
implements IConfigurableObject,
IUpgradeableObject,
InternalInventoryHost,
IConfigInvHost {
    private final AppEngInternalInventory cell = new AppEngInternalInventory((InternalInventoryHost)this, 1, 1);
    private final GenericStackInv config = new GenericStackInv(this::configChanged, GenericStackInv.Mode.CONFIG_TYPES, 63);
    private final ConfigManager manager = new ConfigManager(this::saveChanges);
    private IUpgradeInventory cacheUpgrades = null;
    private ConfigInventory cacheConfig = null;
    private boolean locked = false;

    public PortableCellWorkbenchMenuHost(Player player, int inventorySlot, ItemStack stack) {
        super(player, Integer.valueOf(inventorySlot), stack);
        this.manager.registerSetting(Settings.COPY_MODE, (Enum)CopyMode.CLEAR_ON_REMOVE);
        this.cell.setEnableClientEvents(true);
        CompoundTag itemTag = this.getItemStack().m_41737_("portable_cell_stack");
        if (itemTag != null) {
            this.cell.readFromNBT(itemTag, "cell");
        }
    }

    public ICellWorkbenchItem getCell() {
        if (this.cell.getStackInSlot(0).m_41619_()) {
            return null;
        }
        if (this.cell.getStackInSlot(0).m_41720_() instanceof ICellWorkbenchItem) {
            return (ICellWorkbenchItem)this.cell.getStackInSlot(0).m_41720_();
        }
        return null;
    }

    public IConfigManager getConfigManager() {
        return this.manager;
    }

    public GenericStackInv getConfig() {
        return this.config;
    }

    private void configChanged() {
        if (this.locked) {
            return;
        }
        this.locked = true;
        try {
            ConfigInventory c = this.getCellConfigInventory();
            if (c != null) {
                PortableCellWorkbenchMenuHost.copy(this.config, (GenericStackInv)c);
                PortableCellWorkbenchMenuHost.copy((GenericStackInv)c, this.config);
            }
        }
        finally {
            this.locked = false;
        }
    }

    public static void copy(GenericStackInv from, GenericStackInv to) {
        int i;
        for (i = 0; i < Math.min(from.size(), to.size()); ++i) {
            GenericStack fromStack = from.getStack(i);
            if (fromStack != null && !to.isAllowed(fromStack.what())) {
                fromStack = null;
            }
            to.setStack(i, fromStack);
        }
        for (i = from.size(); i < to.size(); ++i) {
            to.setStack(i, null);
        }
    }

    private ConfigInventory getCellConfigInventory() {
        if (this.cacheConfig == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            ItemStack is = this.cell.getStackInSlot(0);
            if (is.m_41619_()) {
                return null;
            }
            ConfigInventory inv = cell.getConfigInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheConfig = inv;
        }
        return this.cacheConfig;
    }

    public void saveChanges() {
        CompoundTag itemTag = new CompoundTag();
        this.cell.writeToNBT(itemTag, "cell");
        if (!itemTag.m_128456_()) {
            this.getItemStack().m_41700_("portable_cell_stack", (Tag)itemTag);
        } else {
            this.getItemStack().m_41749_("portable_cell_stack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.cell && !this.locked) {
            this.locked = true;
            try {
                this.cacheUpgrades = null;
                this.cacheConfig = null;
                ConfigInventory configInventory = this.getCellConfigInventory();
                if (configInventory != null) {
                    if (!configInventory.isEmpty()) {
                        PortableCellWorkbenchMenuHost.copy((GenericStackInv)configInventory, this.config);
                    } else {
                        PortableCellWorkbenchMenuHost.copy(this.config, (GenericStackInv)configInventory);
                        PortableCellWorkbenchMenuHost.copy((GenericStackInv)configInventory, this.config);
                    }
                } else if (this.manager.getSetting(Settings.COPY_MODE) == CopyMode.CLEAR_ON_REMOVE) {
                    this.config.clear();
                    this.saveChanges();
                }
            }
            finally {
                this.locked = false;
            }
        }
    }

    public IUpgradeInventory getCachedUpgrades() {
        if (this.cacheUpgrades == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return UpgradeInventories.empty();
            }
            ItemStack is = this.cell.getStackInSlot(0);
            if (is.m_41619_()) {
                return UpgradeInventories.empty();
            }
            IUpgradeInventory inv = cell.getUpgrades(is);
            if (inv == null) {
                return UpgradeInventories.empty();
            }
            this.cacheUpgrades = inv;
        }
        return this.cacheUpgrades;
    }

    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.CELLS)) {
            return this.cell;
        }
        return InternalInventory.empty();
    }

    public String getCloseHotkey() {
        return AAEHotkeys.Keys.PATTERN_ENCODER.getId();
    }
}

