/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.patterns;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

class AdvPatternEncoding {
    private static final String NBT_INPUTS = "in";
    private static final String NBT_OUTPUTS = "out";
    private static final String NBT_INPUT_DIRECTIONS = "dir";

    AdvPatternEncoding() {
    }

    public static GenericStack[] getProcessingInputs(CompoundTag nbt) {
        return AdvPatternEncoding.getMixedList(nbt, NBT_INPUTS, 81);
    }

    public static GenericStack[] getProcessingOutputs(CompoundTag nbt) {
        return AdvPatternEncoding.getMixedList(nbt, NBT_OUTPUTS, 27);
    }

    public static GenericStack[] getMixedList(CompoundTag nbt, String nbtKey, int maxSize) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        ListTag tag = nbt.m_128437_(nbtKey, 10);
        Preconditions.checkArgument((tag.size() <= maxSize ? 1 : 0) != 0, (Object)("Cannot use more than " + maxSize + " ingredients"));
        GenericStack[] result = new GenericStack[tag.size()];
        for (int x = 0; x < tag.size(); ++x) {
            CompoundTag entry = tag.m_128728_(x);
            if (entry.m_128456_()) continue;
            GenericStack stack = GenericStack.readTag((CompoundTag)entry);
            if (stack == null) {
                throw new IllegalArgumentException("Pattern references missing stack: " + entry);
            }
            result[x] = stack;
        }
        return result;
    }

    public static LinkedHashMap<AEKey, Direction> getInputDirections(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        ListTag tag = nbt.m_128437_(NBT_INPUT_DIRECTIONS, 10);
        Preconditions.checkArgument((tag.size() <= 9 ? 1 : 0) != 0, (Object)"Cannot use more than 9 ingredients");
        LinkedHashMap<AEKey, Direction> dirMap = new LinkedHashMap<AEKey, Direction>();
        for (int x = 0; x < tag.size(); ++x) {
            CompoundTag compTag = tag.m_128728_(x);
            AEKey key = AEKey.fromTagGeneric((CompoundTag)compTag.m_128469_("aekey"));
            int intTag = compTag.m_128451_(NBT_INPUT_DIRECTIONS);
            Direction dir = intTag == -1 ? null : Direction.m_122376_((int)intTag);
            dirMap.put(key, dir);
        }
        return dirMap;
    }

    public static void encodeProcessingPattern(CompoundTag tag, GenericStack[] sparseInputs, GenericStack[] sparseOutputs, HashMap<AEKey, Direction> dirMap) {
        tag.m_128365_(NBT_INPUTS, (Tag)AdvPatternEncoding.encodeStackList(sparseInputs));
        tag.m_128365_(NBT_OUTPUTS, (Tag)AdvPatternEncoding.encodeStackList(sparseOutputs));
        tag.m_128365_(NBT_INPUT_DIRECTIONS, (Tag)AdvPatternEncoding.encodeDirectionList(dirMap));
    }

    private static ListTag encodeStackList(GenericStack[] stacks) {
        ListTag tag = new ListTag();
        boolean foundStack = false;
        GenericStack[] var3 = stacks;
        int var4 = stacks.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            GenericStack stack = var3[var5];
            tag.add((Object)GenericStack.writeTag((GenericStack)stack));
            if (stack == null || stack.amount() <= 0L) continue;
            foundStack = true;
        }
        Preconditions.checkArgument((boolean)foundStack, (Object)"List passed to pattern must contain at least one stack.");
        return tag;
    }

    private static ListTag encodeDirectionList(HashMap<AEKey, Direction> dirMap) {
        ListTag tag = new ListTag();
        for (Map.Entry<AEKey, Direction> entry : dirMap.entrySet()) {
            CompoundTag dirTag = new CompoundTag();
            dirTag.m_128365_("aekey", (Tag)entry.getKey().toTagGeneric());
            Direction dir = entry.getValue();
            if (dir == null) {
                dirTag.m_128365_(NBT_INPUT_DIRECTIONS, (Tag)IntTag.m_128679_((int)-1));
            } else {
                dirTag.m_128365_(NBT_INPUT_DIRECTIONS, (Tag)IntTag.m_128679_((int)dir.m_122411_()));
            }
            tag.add((Object)dirTag);
        }
        return tag;
    }
}

