/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.common.item.knife.Knives;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DelightfulConfig {
    public static final DelightfulConfig CONFIG;
    public static final ForgeConfigSpec SPEC;
    private static final ImmutableList<String> DEFAULT_DISABLED;
    public static ForgeConfigSpec.BooleanValue CRAFT_NUT_MILK;
    public static ForgeConfigSpec.BooleanValue COOK_CLOVER_HONEY;
    public static ForgeConfigSpec.BooleanValue GIVE_SLICED_DIRECTLY;
    public static ForgeConfigSpec.BooleanValue MELON_JUICING;
    private final Map<String, ForgeConfigSpec.BooleanValue> stuff = new HashMap<String, ForgeConfigSpec.BooleanValue>();

    DelightfulConfig(ForgeConfigSpec.Builder builder) {
        List<String> items = DelightfulItems.ITEMS.getEntries().stream().map(obj -> obj.getId().m_135815_()).sorted().toList();
        builder.comment(" Let's Configure Delightful");
        this.stuff.clear();
        builder.push("Knives");
        items.stream().filter(path -> path.contains("_knife")).forEach(knife -> DelightfulConfig.put(builder, this.stuff, knife, !DEFAULT_DISABLED.contains(knife)));
        builder.pop();
        builder.push("Pie Overhauls");
        items.stream().filter(path -> path.contains("_pie_slice")).forEach(knife -> DelightfulConfig.put(builder, this.stuff, knife, !DEFAULT_DISABLED.contains(knife)));
        builder.pop();
        builder.push("Registry & Recipes");
        items.stream().filter(path -> !path.contains("_knife") && !path.contains("_pie_slice")).forEach(not -> DelightfulConfig.put(builder, this.stuff, not, !DEFAULT_DISABLED.contains(not)));
        CRAFT_NUT_MILK = builder.comment("Allow cooking milk from nuts").define("nut_milk", true);
        this.stuff.put("nut_milk", CRAFT_NUT_MILK);
        COOK_CLOVER_HONEY = builder.comment("Allow cooking honey from honey and clovers").define("clover_honey", false);
        this.stuff.put("clover_honey", COOK_CLOVER_HONEY);
        GIVE_SLICED_DIRECTLY = builder.comment("Give items that are sliced off of blocks directly to player's inventory instead of dropping").define("give_sliced_directly", false);
        MELON_JUICING = builder.comment("Allow sliced melons to be juiced in-world (right click)").define("melon_juicing", true);
        builder.pop();
    }

    private static void put(ForgeConfigSpec.Builder builder, Map<String, ForgeConfigSpec.BooleanValue> map, String name, boolean def) {
        map.put(name, builder.define(name, def));
    }

    public boolean verify(String item) {
        return DelightfulConfig.CONFIG.stuff.containsKey(item) && (Boolean)DelightfulConfig.CONFIG.stuff.get(item).get() != false;
    }

    static {
        DEFAULT_DISABLED = ImmutableList.of((Object)Util.name(Knives.COPPER), (Object)Util.name(Knives.AMETHYST), (Object)Util.name(Knives.EMERALD), (Object)Util.name(Knives.LAPIS_LAZULI), (Object)Util.name(Knives.NETHER_QUARTZ));
        Pair pair = new ForgeConfigSpec.Builder().configure(DelightfulConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        CONFIG = (DelightfulConfig)pair.getLeft();
    }
}

