/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.ICompat;
import net.brnbrd.delightful.common.item.IConfigured;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.KnifeItem;

public class DelightfulKnifeItem
extends KnifeItem
implements IConfigured {
    private final TagKey<Item> tag;

    public DelightfulKnifeItem(TagKey<Item> tag, Tier tier, Item.Properties properties) {
        super(tier, 0.5f, -2.0f, properties);
        this.tag = tag;
    }

    public boolean m_6832_(@NotNull ItemStack pToRepair, @NotNull ItemStack pRepair) {
        return this.enabled() && super.m_6832_(pToRepair, pRepair);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> comps, @NotNull TooltipFlag pIsAdvanced) {
        if (this.enabledText(comps) && !(this instanceof ICompat) && this.enabled() && !this.isTag() && this.getTag() != null) {
            comps.add((Component)Component.m_237115_((String)"tooltip.requires_tag"));
            comps.add((Component)Component.m_237113_((String)this.getTag().f_203868_().toString()).m_130940_(ChatFormatting.UNDERLINE));
        }
        super.m_7373_(stack, level, comps, pIsAdvanced);
    }

    @Nullable
    public TagKey<Item> getTag() {
        return this.tag;
    }

    public boolean isTag() {
        return Util.tagPopulated(this.getTag());
    }

    @Override
    public boolean enabled() {
        return IConfigured.super.enabled() && this.isTag();
    }

    public Ingredient getRod() {
        return Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN);
    }

    @NotNull
    public ItemStack getCreativeItem() {
        return new ItemStack((ItemLike)this);
    }

    @Nullable
    public RecipeType<?> getRecipeType() {
        return RecipeType.f_44107_;
    }

    @Nullable
    public Lazy<Multimap<Attribute, AttributeModifier>> getModifiers(EquipmentSlot slot, ItemStack stack) {
        return null;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap mods = super.getAttributeModifiers(slot, stack);
        Lazy<Multimap<Attribute, AttributeModifier>> additional = this.getModifiers(slot, stack);
        if (this.enabled() && slot == EquipmentSlot.MAINHAND && additional != null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            if (!mods.isEmpty()) {
                builder.putAll(mods);
            }
            builder.putAll((Multimap)additional.get());
            return builder.build();
        }
        return mods;
    }

    public String getTranslation() {
        return StringUtils.capitaliseAllWords((String)this.m_5524_().toLowerCase(Locale.ROOT).replace("item." + "delightful".toLowerCase(Locale.ROOT) + ".", "").replace("_", " "));
    }

    public List<Component> getTools() {
        return Collections.emptyList();
    }
}

