/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife.compat.aether;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import net.brnbrd.delightful.common.item.DelightfulTiers;
import net.brnbrd.delightful.common.item.knife.compat.aether.AetherKnifeItem;
import net.brnbrd.delightful.data.tags.DelightfulItemTags;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ZaniteKnifeItem
extends AetherKnifeItem {
    public ZaniteKnifeItem(Item.Properties properties) {
        super(DelightfulItemTags.GEMS_ZANITE, DelightfulTiers.ZANITE, properties, new ChatFormatting[0]);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> map = super.getAttributeModifiers(slot, stack);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (this.enabled() && slot == EquipmentSlot.MAINHAND) {
            builder.putAll(map);
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Attack damage modifier", (double)this.calculateIncrease(map, stack), AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return map;
    }

    private int calculateIncrease(Multimap<Attribute, AttributeModifier> map, ItemStack stack) {
        double baseDamage = 0.0;
        Iterator it = map.get((Object)Attributes.f_22281_).stream().iterator();
        while (it.hasNext()) {
            AttributeModifier modifier = (AttributeModifier)it.next();
            baseDamage += modifier.m_22218_();
        }
        double boostedDamage = baseDamage * (2.0 * (double)stack.m_41773_() / (double)stack.m_41776_() + 0.5);
        if ((boostedDamage -= baseDamage) < 0.0) {
            boostedDamage = 0.0;
        }
        return (int)Math.round(boostedDamage);
    }
}

